/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.muse.core.Persistence;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.ResourceManagerListener;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.LoggingUtils;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.notification.NotificationProducerPersistence;
import org.apache.muse.ws.notification.Policy;
import org.apache.muse.ws.notification.SubscriptionManager;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.notification.faults.NoCurrentMessageOnTopicFault;
import org.apache.muse.ws.notification.faults.SubscribeCreationFailedFault;
import org.apache.muse.ws.notification.faults.TopicNotSupportedFault;
import org.apache.muse.ws.notification.faults.UnacceptableInitialTerminationTimeFault;
import org.apache.muse.ws.notification.impl.GetCurrentMessageHandler;
import org.apache.muse.ws.notification.impl.ProducerPropertiesFilter;
import org.apache.muse.ws.notification.impl.PublishAllMessagesFilter;
import org.apache.muse.ws.notification.impl.SimpleNotificationMessage;
import org.apache.muse.ws.notification.impl.SubscribeHandler;
import org.apache.muse.ws.notification.impl.TopicFilter;
import org.apache.muse.ws.notification.properties.ChangeNotificationListenerFactory;
import org.apache.muse.ws.notification.properties.WsrpNotificationListenerFactory;
import org.apache.muse.ws.notification.topics.Topic;
import org.apache.muse.ws.notification.topics.TopicNamespace;
import org.apache.muse.ws.notification.topics.TopicSet;
import org.apache.muse.ws.notification.topics.impl.SimpleTopic;
import org.apache.muse.ws.notification.topics.impl.SimpleTopicNamespace;
import org.apache.muse.ws.notification.topics.impl.SimpleTopicSet;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.impl.AbstractWsResourceCapability;
import org.apache.muse.ws.resource.lifetime.ScheduledTermination;
import org.apache.muse.ws.resource.lifetime.WsrlConstants;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.properties.ResourcePropertyCollection;
import org.apache.muse.ws.resource.properties.listeners.PropertyChangeListener;
import org.w3c.dom.Element;

public class SimpleNotificationProducer
extends AbstractWsResourceCapability
implements NotificationProducer,
ResourceManagerListener {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$notification$impl$SimpleNotificationProducer == null ? (class$org$apache$muse$ws$notification$impl$SimpleNotificationProducer = SimpleNotificationProducer.class$("org.apache.muse.ws.notification.impl.SimpleNotificationProducer")) : class$org$apache$muse$ws$notification$impl$SimpleNotificationProducer);
    private Set _allTopicNames = new HashSet();
    private ChangeNotificationListenerFactory _listenerFactory = null;
    private String _subscriptionPath = null;
    private Map _subscriptionsByEPR = new HashMap();
    private TopicSet _topicSet = new SimpleTopicSet();
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$SimpleNotificationProducer;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$SubscriptionManager;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$NotificationProducerPersistence;

    public synchronized void addSubscription(WsResource sub) {
        SubscriptionManager subMgr = (SubscriptionManager)sub.getCapability("http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager");
        EndpointReference epr = sub.getEndpointReference();
        this._subscriptionsByEPR.put(epr, subMgr);
    }

    public Topic addTopic(QName topicName) throws BaseFault {
        String namespace = topicName.getNamespaceURI();
        TopicNamespace topicSpace = this.getTopicNamespace(namespace);
        if (topicSpace == null) {
            topicSpace = this.addTopicNamespace(namespace);
        }
        String localName = topicName.getLocalPart();
        SimpleTopic topic = new SimpleTopic(localName, topicSpace);
        topicSpace.addTopic(topic);
        this._allTopicNames.add(topicName);
        return topic;
    }

    public TopicNamespace addTopicNamespace(String namespace) throws BaseFault {
        SimpleTopicNamespace topics = new SimpleTopicNamespace(namespace);
        topics.setName("ResourcePropertiesTopicSpace");
        this._topicSet.addTopicNamespace(topics);
        return topics;
    }

    protected MessageHandler createGetCurrentMessageHandler() {
        GetCurrentMessageHandler handler = new GetCurrentMessageHandler();
        Method method = ReflectUtils.getFirstMethod(this.getClass(), "getCurrentMessage");
        handler.setMethod(method);
        return handler;
    }

    protected ChangeNotificationListenerFactory createNotificationListenerFactory() {
        return new WsrpNotificationListenerFactory();
    }

    protected NotificationMessage createNotificationMessage() {
        return new SimpleNotificationMessage();
    }

    protected MessageHandler createSubscribeHandler() {
        SubscribeHandler handler = new SubscribeHandler();
        Method method = ReflectUtils.getFirstMethod(this.getClass(), "subscribe");
        handler.setMethod(method);
        return handler;
    }

    public NotificationMessage getCurrentMessage(QName topicPath) throws NoCurrentMessageOnTopicFault, TopicNotSupportedFault {
        Topic topic = this.getTopic(topicPath);
        if (topic == null) {
            Object[] filler = new Object[]{topicPath};
            throw new TopicNotSupportedFault(_MESSAGES.get("TopicNotFound", filler));
        }
        NotificationMessage message = topic.getCurrentMessage();
        if (message == null) {
            Object[] filler = new Object[]{topicPath};
            throw new NoCurrentMessageOnTopicFault(_MESSAGES.get("NoMessageAvailable", filler));
        }
        return message;
    }

    public boolean getFixedTopicSet() {
        return true;
    }

    protected ChangeNotificationListenerFactory getNotificationListenerFactory() {
        return this._listenerFactory;
    }

    public QName[] getPropertyNames() {
        return NotificationProducer.PROPERTIES;
    }

    protected String getSubscriptionContextPath() {
        return this._subscriptionPath;
    }

    protected synchronized Collection getSubscriptions() {
        return Collections.unmodifiableCollection(this._subscriptionsByEPR.values());
    }

    public Topic getTopic(QName topicName) {
        TopicNamespace topicSpace = this.getTopicNamespace(topicName.getNamespaceURI());
        if (topicSpace == null) {
            return null;
        }
        return topicSpace.getTopic(topicName.getLocalPart());
    }

    public QName[] getTopicExpression() {
        QName[] array = new QName[this._allTopicNames.size()];
        return this._allTopicNames.toArray(array);
    }

    public String[] getTopicExpressionDialect() {
        return new String[]{"http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete"};
    }

    public TopicNamespace getTopicNamespace(String namespace) {
        return this.getTopicSet().getTopicNamespace(namespace);
    }

    public TopicSet getTopicSet() {
        return this._topicSet;
    }

    protected boolean hasSubscription(EndpointReference subscriptionEPR) {
        return this._subscriptionsByEPR.containsKey(subscriptionEPR);
    }

    public boolean hasTopic(QName topicName) {
        return this._allTopicNames.contains(topicName);
    }

    public void initialize() throws SoapFault {
        super.initialize();
        this._listenerFactory = this.createNotificationListenerFactory();
        this.setMessageHandler(this.createSubscribeHandler());
        this.setMessageHandler(this.createGetCurrentMessageHandler());
        WsResource resource = this.getWsResource();
        ResourceManager manager = resource.getResourceManager();
        this._subscriptionPath = manager.getResourceContextPath(class$org$apache$muse$ws$notification$SubscriptionManager == null ? (class$org$apache$muse$ws$notification$SubscriptionManager = SimpleNotificationProducer.class$("org.apache.muse.ws.notification.SubscriptionManager")) : class$org$apache$muse$ws$notification$SubscriptionManager);
        if (this._subscriptionPath == null) {
            throw new RuntimeException(_MESSAGES.get("NoSubscriptionManager"));
        }
        Persistence persistence = this.getPersistence();
        if (persistence != null) {
            if (!(class$org$apache$muse$ws$notification$NotificationProducerPersistence == null ? (class$org$apache$muse$ws$notification$NotificationProducerPersistence = SimpleNotificationProducer.class$("org.apache.muse.ws.notification.NotificationProducerPersistence")) : class$org$apache$muse$ws$notification$NotificationProducerPersistence).isAssignableFrom(persistence.getClass())) {
                Object[] filler = new Object[]{class$org$apache$muse$ws$notification$NotificationProducerPersistence == null ? (class$org$apache$muse$ws$notification$NotificationProducerPersistence = SimpleNotificationProducer.class$("org.apache.muse.ws.notification.NotificationProducerPersistence")) : class$org$apache$muse$ws$notification$NotificationProducerPersistence, persistence.getClass()};
                throw new RuntimeException(_MESSAGES.get("IncorrectPersistenceRoot", filler));
            }
            NotificationProducerPersistence npPersistence = (NotificationProducerPersistence)persistence;
            npPersistence.setNotificationProducer(this);
        }
        manager.addListener(this);
    }

    public void initializeCompleted() throws SoapFault {
        MetadataDescriptor rmd;
        super.initializeCompleted();
        ChangeNotificationListenerFactory factory = this.getNotificationListenerFactory();
        WsResource resource = this.getWsResource();
        ResourcePropertyCollection props = resource.getPropertyCollection();
        Iterator i = props.getPropertyNames().iterator();
        while (i.hasNext()) {
            QName name = (QName)i.next();
            this.addTopic(name);
            PropertyChangeListener listener = factory.newInstance(name, resource);
            props.addChangeListener(listener);
        }
        if (resource.hasCapability("http://docs.oasis-open.org/wsrf/rlw-2/ImmediateResourceTermination") || resource.hasCapability("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination")) {
            this.addTopic(WsrlConstants.TERMINATION_TOPIC_QNAME);
        }
        if ((rmd = props.getMetadata()).hasProperty(WsnConstants.TOPIC_EXPRESSION_QNAME)) {
            Collection[] values = new Collection[]{rmd.getInitialValues(WsnConstants.TOPIC_EXPRESSION_QNAME), rmd.getStaticValues(WsnConstants.TOPIC_EXPRESSION_QNAME)};
            for (int n = 0; n < values.length; ++n) {
                i = values[n].iterator();
                while (i.hasNext()) {
                    Element topicExpression = (Element)i.next();
                    QName topicName = XmlUtils.getQName(topicExpression);
                    this.addTopic(topicName);
                }
            }
        }
    }

    public void prepareShutdown() throws SoapFault {
        if (this.hasTopic(WsrlConstants.TERMINATION_TOPIC_QNAME)) {
            Element payload = XmlUtils.createElement(WsrlConstants.NOTIFICATION_QNAME);
            XmlUtils.setElement(payload, WsrlConstants.TERMINATION_TIME_QNAME, new Date());
            this.publish(WsrlConstants.TERMINATION_TOPIC_QNAME, payload);
        }
        super.prepareShutdown();
    }

    public void publish(QName topicName, Element content) throws SoapFault {
        this.publish(topicName, new Element[]{content});
    }

    public void publish(QName topicName, Element[] content) throws SoapFault {
        NotificationMessage message = this.createNotificationMessage();
        for (int n = 0; n < content.length; ++n) {
            message.addMessageContent(content[n]);
        }
        message.setTopic(topicName);
        Iterator i = this.getSubscriptions().iterator();
        while (i.hasNext()) {
            SubscriptionManager sub = (SubscriptionManager)i.next();
            sub.publish(message);
        }
        if (topicName != null) {
            Topic topic = this.getTopic(topicName);
            topic.setCurrentMessage(message);
        }
    }

    public void publish(QName topicName, XmlSerializable content) throws SoapFault {
        this.publish(topicName, new XmlSerializable[]{content});
    }

    public void publish(QName topicName, XmlSerializable[] content) throws SoapFault {
        Element[] contentXML = new Element[content.length];
        for (int n = 0; n < content.length; ++n) {
            contentXML[n] = content[n].toXML();
        }
        this.publish(topicName, contentXML);
    }

    public void publish(QName topicName, QName contentName, Object content) throws SoapFault {
        this.publish(topicName, new QName[]{contentName}, new Object[]{content});
    }

    public void publish(QName topicName, QName[] contentNames, Object[] content) throws SoapFault {
        SerializerRegistry registry = SerializerRegistry.getInstance();
        Element[] contentXML = new Element[content.length];
        for (int n = 0; n < content.length; ++n) {
            Class<?> contentType = content[n].getClass();
            Serializer ser = registry.getSerializer(contentType);
            contentXML[n] = ser.toXML(content[n], contentNames[n]);
        }
        this.publish(topicName, contentXML);
    }

    public synchronized void removeSubscription(EndpointReference epr) {
        this._subscriptionsByEPR.remove(epr);
    }

    public void resourceAdded(EndpointReference epr, Resource resource) {
    }

    public void resourceRemoved(EndpointReference epr) {
        boolean subExists = this.hasSubscription(epr);
        if (!subExists) {
            return;
        }
        this.removeSubscription(epr);
        NotificationProducerPersistence persistence = (NotificationProducerPersistence)this.getPersistence();
        try {
            if (persistence != null) {
                persistence.resourceRemoved(epr);
            }
        }
        catch (SoapFault fault) {
            LoggingUtils.logError(this.getLog(), fault);
        }
    }

    public WsResource subscribe(EndpointReference consumer, Filter filter, Date terminationTime, Policy policy) throws TopicNotSupportedFault, UnacceptableInitialTerminationTimeFault, SubscribeCreationFailedFault {
        if (consumer == null) {
            throw new NullPointerException(_MESSAGES.get("NullConsumerEPR"));
        }
        if (filter == null) {
            filter = PublishAllMessagesFilter.getInstance();
        }
        if (filter instanceof TopicFilter) {
            TopicFilter topicFilter = (TopicFilter)filter;
            QName topicName = topicFilter.getTopic();
            if (!this.hasTopic(topicName)) {
                Object[] filler = new Object[]{topicName};
                throw new TopicNotSupportedFault(_MESSAGES.get("TopicNotFound", filler));
            }
            Topic topic = this.getTopic(topicName);
            topicFilter.setTopic(topic);
        } else if (filter instanceof ProducerPropertiesFilter) {
            ProducerPropertiesFilter propertiesFilter = (ProducerPropertiesFilter)filter;
            propertiesFilter.setResource(this.getWsResource());
        }
        WsResource producer = this.getWsResource();
        ResourceManager manager = producer.getResourceManager();
        String endpoint = this.getSubscriptionContextPath();
        WsResource sub = null;
        try {
            sub = (WsResource)manager.createResource(endpoint);
        }
        catch (SoapFault error) {
            throw new SubscribeCreationFailedFault(error);
        }
        SubscriptionManager subMgr = (SubscriptionManager)sub.getCapability("http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager");
        EndpointReference producerEPR = producer.getEndpointReference();
        subMgr.setProducerReference(producerEPR);
        subMgr.setConsumerReference(consumer);
        subMgr.setFilter(filter);
        subMgr.setSubscriptionPolicy(policy);
        try {
            sub.initialize();
            manager.addResource(sub.getEndpointReference(), sub);
        }
        catch (SoapFault error) {
            throw new SubscribeCreationFailedFault(error);
        }
        if (sub.hasCapability("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination")) {
            ScheduledTermination wsrl = (ScheduledTermination)sub.getCapability("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination");
            try {
                wsrl.setTerminationTime(terminationTime);
            }
            catch (BaseFault error) {
                throw new UnacceptableInitialTerminationTimeFault(error);
            }
        }
        this.addSubscription(sub);
        NotificationProducerPersistence persistence = (NotificationProducerPersistence)this.getPersistence();
        try {
            if (persistence != null) {
                persistence.resourceAdded(sub.getEndpointReference(), sub);
            }
        }
        catch (SoapFault fault) {
            LoggingUtils.logError(this.getLog(), fault);
        }
        return sub;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

