/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.notification.faults.TopicExpressionDialectUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleNotificationMessage
implements XmlSerializable,
NotificationMessage {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$notification$impl$SimpleNotificationMessage == null ? (class$org$apache$muse$ws$notification$impl$SimpleNotificationMessage = SimpleNotificationMessage.class$("org.apache.muse.ws.notification.impl.SimpleNotificationMessage")) : class$org$apache$muse$ws$notification$impl$SimpleNotificationMessage);
    private Map _messageContent = new LinkedHashMap();
    private EndpointReference _producer = null;
    private EndpointReference _subscription = null;
    private QName _topicPath = null;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$SimpleNotificationMessage;

    public SimpleNotificationMessage() {
    }

    public SimpleNotificationMessage(Element root) throws SoapFault {
        Element messageXML;
        Element subXML;
        if (root == null) {
            throw new NullPointerException(_MESSAGES.get("NullMessageElement"));
        }
        this._topicPath = XmlUtils.getQNameFromChild(root, WsnConstants.TOPIC_QNAME);
        Element producerXML = XmlUtils.getElement(root, WsnConstants.PRODUCER_QNAME);
        if (producerXML != null) {
            this._producer = new EndpointReference(producerXML);
        }
        if ((subXML = XmlUtils.getElement(root, WsnConstants.SUBSCRIPTION_EPR_QNAME)) != null) {
            this._subscription = new EndpointReference(subXML);
        }
        if ((messageXML = XmlUtils.getElement(root, WsnConstants.MESSAGE_QNAME)) == null) {
            throw new SoapFault(_MESSAGES.get("NoMessageContent"));
        }
        Element[] children = XmlUtils.getAllElements(messageXML);
        for (int n = 0; n < children.length; ++n) {
            this.addMessageContent(children[n]);
        }
    }

    public SimpleNotificationMessage(QName topicPath) {
        this._topicPath = topicPath;
    }

    public void addMessageContent(Element content) {
        if (content == null) {
            throw new NullPointerException(_MESSAGES.get("NullMessageContent"));
        }
        QName name = XmlUtils.getElementQName(content);
        this._messageContent.put(name, content);
    }

    public void addMessageContent(QName qname, Object content) throws SoapFault {
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullContentName"));
        }
        if (content == null) {
            throw new NullPointerException(_MESSAGES.get("NullMessageContent"));
        }
        SerializerRegistry registry = SerializerRegistry.getInstance();
        Serializer ser = registry.getSerializer(content.getClass());
        Element xml = ser.toXML(content, qname);
        this._messageContent.put(qname, xml);
    }

    public Element getMessageContent(QName qname) {
        return (Element)this._messageContent.get(qname);
    }

    public Object getMessageContent(QName qname, Class type) throws SoapFault {
        Element content = this.getMessageContent(qname);
        SerializerRegistry registry = SerializerRegistry.getInstance();
        Serializer ser = registry.getSerializer(type);
        return ser.fromXML(content);
    }

    public Collection getMessageContentNames() {
        return Collections.unmodifiableSet(this._messageContent.keySet());
    }

    public EndpointReference getProducerReference() {
        return this._producer;
    }

    public EndpointReference getSubscriptionReference() {
        return this._subscription;
    }

    public QName getTopic() {
        return this._topicPath;
    }

    public String getTopicDialect() {
        return "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";
    }

    public void setProducerReference(EndpointReference producer) {
        this._producer = producer == null ? null : new EndpointReference(producer, WsnConstants.PRODUCER_QNAME);
    }

    public void setSubscriptionReference(EndpointReference subscription) {
        this._subscription = subscription;
    }

    public void setTopic(QName topicPath) {
        this._topicPath = topicPath;
    }

    public void setTopicDialect(String dialect) throws TopicExpressionDialectUnknownFault {
        if (dialect == null || !dialect.equals("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete")) {
            Object[] filler = new Object[]{dialect, "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete"};
            throw new TopicExpressionDialectUnknownFault(_MESSAGES.get("InvalidDialect", filler));
        }
    }

    public String toString() {
        return XmlUtils.toString(this.toXML(), false);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        EndpointReference producer;
        QName topicPath;
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        Element root = XmlUtils.createElement(doc, WsnConstants.NOTIFICATION_MSG_QNAME);
        EndpointReference sub = this.getSubscriptionReference();
        if (sub != null) {
            Element eprXML = sub.toXML(doc);
            XmlUtils.setElement(root, WsnConstants.SUBSCRIPTION_EPR_QNAME, eprXML);
        }
        if ((topicPath = this.getTopic()) != null) {
            Element topic = XmlUtils.createElement(doc, WsnConstants.TOPIC_QNAME, topicPath);
            topic.setAttribute("Dialect", this.getTopicDialect());
            root.appendChild(topic);
        }
        if ((producer = this.getProducerReference()) != null) {
            Element eprXML = producer.toXML(doc);
            XmlUtils.setElement(root, WsnConstants.PRODUCER_QNAME, eprXML);
        }
        Element message = XmlUtils.createElement(doc, WsnConstants.MESSAGE_QNAME);
        root.appendChild(message);
        Iterator<Object> i = this.getMessageContentNames().iterator();
        while (i.hasNext()) {
            QName name = (QName)i.next();
            Element next = this.getMessageContent(name);
            next = (Element)doc.importNode(next, true);
            message.appendChild(next);
        }
        Map namespacesByPrefix = XmlUtils.getAllNamespaces(root);
        i = namespacesByPrefix.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String namespace = (String)namespacesByPrefix.get(prefix);
            XmlUtils.setNamespaceAttribute(root, prefix, namespace);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

