/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.WsnConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilterCollection
implements Filter {
    private Collection _filters = new ArrayList();

    public boolean accepts(NotificationMessage message) {
        Iterator i = this.getFilters().iterator();
        while (i.hasNext()) {
            Filter next = (Filter)i.next();
            if (next.accepts(message)) continue;
            return false;
        }
        return true;
    }

    public void addFilter(Filter filter) {
        this._filters.add(filter);
    }

    public Collection getFilters() {
        return Collections.unmodifiableCollection(this._filters);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Element filterXML = XmlUtils.createElement(doc, WsnConstants.FILTER_QNAME);
        Iterator i = this.getFilters().iterator();
        while (i.hasNext()) {
            Filter next = (Filter)i.next();
            Element nextXML = next.toXML(doc);
            XmlUtils.moveSubTree(nextXML, filterXML);
        }
        return filterXML;
    }
}

