/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.serializer;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.muse.core.serializer.ArraySerializer;
import org.apache.muse.core.serializer.BooleanSerializer;
import org.apache.muse.core.serializer.DateSerializer;
import org.apache.muse.core.serializer.DoubleSerializer;
import org.apache.muse.core.serializer.ElementSerializer;
import org.apache.muse.core.serializer.FloatSerializer;
import org.apache.muse.core.serializer.IntegerSerializer;
import org.apache.muse.core.serializer.LongSerializer;
import org.apache.muse.core.serializer.QNameSerializer;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.ShortSerializer;
import org.apache.muse.core.serializer.StringSerializer;
import org.apache.muse.core.serializer.UriSerializer;
import org.apache.muse.core.serializer.UrlSerializer;
import org.apache.muse.core.serializer.XmlSerializableSerializer;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;

public class SerializerRegistry {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$serializer$SerializerRegistry == null ? (class$org$apache$muse$core$serializer$SerializerRegistry = SerializerRegistry.class$("org.apache.muse.core.serializer.SerializerRegistry")) : class$org$apache$muse$core$serializer$SerializerRegistry);
    private static final SerializerRegistry _SINGLETON = new SerializerRegistry();
    private Map _serializers = new TreeMap(new ClassComparator());
    static /* synthetic */ Class class$org$apache$muse$core$serializer$SerializerRegistry;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$org$apache$muse$util$xml$XmlSerializable;
    static /* synthetic */ Class class$java$lang$Object;

    public static SerializerRegistry getInstance() {
        return _SINGLETON;
    }

    private SerializerRegistry() {
        this.registerSerializer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializerRegistry.class$("java.lang.Boolean")) : class$java$lang$Boolean, new BooleanSerializer());
        this.registerSerializer(Boolean.TYPE, new BooleanSerializer());
        this.registerSerializer(class$java$lang$Double == null ? (class$java$lang$Double = SerializerRegistry.class$("java.lang.Double")) : class$java$lang$Double, new DoubleSerializer());
        this.registerSerializer(Double.TYPE, new DoubleSerializer());
        this.registerSerializer(class$java$lang$Float == null ? (class$java$lang$Float = SerializerRegistry.class$("java.lang.Float")) : class$java$lang$Float, new FloatSerializer());
        this.registerSerializer(Float.TYPE, new FloatSerializer());
        this.registerSerializer(class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerRegistry.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegerSerializer());
        this.registerSerializer(Integer.TYPE, new IntegerSerializer());
        this.registerSerializer(class$java$lang$Long == null ? (class$java$lang$Long = SerializerRegistry.class$("java.lang.Long")) : class$java$lang$Long, new LongSerializer());
        this.registerSerializer(Long.TYPE, new LongSerializer());
        this.registerSerializer(class$java$lang$Short == null ? (class$java$lang$Short = SerializerRegistry.class$("java.lang.Short")) : class$java$lang$Short, new ShortSerializer());
        this.registerSerializer(Short.TYPE, new ShortSerializer());
        this.registerSerializer(class$java$lang$String == null ? (class$java$lang$String = SerializerRegistry.class$("java.lang.String")) : class$java$lang$String, new StringSerializer());
        this.registerSerializer(class$java$net$URI == null ? (class$java$net$URI = SerializerRegistry.class$("java.net.URI")) : class$java$net$URI, new UriSerializer());
        this.registerSerializer(class$java$net$URL == null ? (class$java$net$URL = SerializerRegistry.class$("java.net.URL")) : class$java$net$URL, new UrlSerializer());
        this.registerSerializer(class$java$util$Date == null ? (class$java$util$Date = SerializerRegistry.class$("java.util.Date")) : class$java$util$Date, new DateSerializer());
        this.registerSerializer(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = SerializerRegistry.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, new QNameSerializer());
        this.registerSerializer(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = SerializerRegistry.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element, new ElementSerializer());
        this.registerSerializer(class$org$apache$muse$util$xml$XmlSerializable == null ? (class$org$apache$muse$util$xml$XmlSerializable = SerializerRegistry.class$("org.apache.muse.util.xml.XmlSerializable")) : class$org$apache$muse$util$xml$XmlSerializable, new XmlSerializableSerializer());
    }

    public Serializer getSerializer(Class type) {
        if (type == null) {
            throw new NullPointerException(_MESSAGES.get("NullClass"));
        }
        Serializer ser = this.searchClassHierarchy(type);
        if (ser != null) {
            return ser;
        }
        Iterator i = this._serializers.keySet().iterator();
        StringBuffer availableTypes = new StringBuffer(1024);
        availableTypes.append('\n');
        while (i.hasNext()) {
            availableTypes.append('\n');
            availableTypes.append(i.next());
        }
        Object[] filler = new Object[]{type, availableTypes};
        throw new RuntimeException(_MESSAGES.get("NoSerializer", filler));
    }

    public void registerSerializer(Class type, Serializer ser) {
        if (type == null) {
            throw new NullPointerException(_MESSAGES.get("NullClass"));
        }
        if (ser == null) {
            throw new NullPointerException(_MESSAGES.get("NullSerializer"));
        }
        Class arrayType = ReflectUtils.getArrayClassFromClass(type);
        ArraySerializer array = new ArraySerializer(arrayType, ser);
        this._serializers.put(type, ser);
        this._serializers.put(arrayType, array);
    }

    protected Serializer searchClassHierarchy(Class type) {
        Serializer ser = (Serializer)this._serializers.get(type);
        if (ser != null) {
            return ser;
        }
        Class parent = type.getSuperclass();
        if (parent != null && parent != (class$java$lang$Object == null ? (class$java$lang$Object = SerializerRegistry.class$("java.lang.Object")) : class$java$lang$Object) && (ser = this.searchClassHierarchy(parent)) != null) {
            return ser;
        }
        Class<?>[] interfaces = type.getInterfaces();
        for (int n = 0; n < interfaces.length; ++n) {
            ser = this.searchClassHierarchy(interfaces[n]);
            if (ser == null) continue;
            return ser;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ClassComparator
    implements Comparator {
        protected ClassComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Class class1 = (Class)obj1;
            Class class2 = (Class)obj2;
            return class1.getName().compareTo(class2.getName());
        }
    }
}

