/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.routing;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.muse.core.Environment;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.SimpleResourceManager;
import org.apache.muse.core.descriptor.ResourceDefinition;
import org.apache.muse.core.routing.ResourceRouter;
import org.apache.muse.core.routing.RouterPersistence;
import org.apache.muse.util.LoggingUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.MessageHeaders;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Element;

public class SimpleResourceRouter
implements ResourceRouter {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$routing$SimpleResourceRouter == null ? (class$org$apache$muse$core$routing$SimpleResourceRouter = SimpleResourceRouter.class$("org.apache.muse.core.routing.SimpleResourceRouter")) : class$org$apache$muse$core$routing$SimpleResourceRouter);
    private Environment _environment = null;
    private boolean _hasBeenInitialized = false;
    private boolean _hasBeenShutdown = false;
    private Logger _log = null;
    private RouterPersistence _persistence = null;
    private Collection _resourceDefinitions = null;
    private ResourceManager _resourceManager = null;
    static /* synthetic */ Class class$org$apache$muse$core$routing$SimpleResourceRouter;

    protected ResourceManager createResourceManager() {
        return new SimpleResourceManager();
    }

    public Environment getEnvironment() {
        return this._environment;
    }

    public Logger getLog() {
        return this._log;
    }

    public RouterPersistence getPersistence() {
        return this._persistence;
    }

    public Collection getResourceDefinitions() {
        return this._resourceDefinitions;
    }

    public ResourceManager getResourceManager() {
        return this._resourceManager;
    }

    protected Resource getTargetResource() throws SoapFault {
        ResourceManager manager = this.getResourceManager();
        Environment env = this.getEnvironment();
        MessageHeaders wsa = env.getAddressingContext();
        if (wsa == null) {
            throw new RuntimeException(_MESSAGES.get("NoAddressingContext"));
        }
        EndpointReference epr = wsa.getToAddress();
        Resource resource = manager.getResource(epr);
        if (resource == null) {
            StringBuffer eprNotFound = new StringBuffer(512);
            eprNotFound.append("\n\n");
            eprNotFound.append(epr);
            eprNotFound.append('\n');
            Iterator i = manager.getResourceEPRs();
            StringBuffer eprListing = new StringBuffer(1024);
            eprListing.append('\n');
            while (i.hasNext()) {
                eprListing.append('\n');
                eprListing.append(i.next());
            }
            Object[] filler = new Object[]{eprNotFound, eprListing};
            SoapFault wsaFault = new SoapFault(_MESSAGES.get("DestinationUnreachable", filler));
            wsaFault.setCode(SoapConstants.SENDER_QNAME);
            wsaFault.setSubCode(WsaConstants.DESTINATION_UNREACHABLE_FAULT_QNAME);
            throw wsaFault;
        }
        return resource;
    }

    public boolean hasBeenInitialized() {
        return this._hasBeenInitialized;
    }

    public boolean hasBeenShutdown() {
        return this._hasBeenShutdown;
    }

    public void initialize() throws SoapFault {
        Logger log = this.getLog();
        if (log == null) {
            throw new IllegalStateException(_MESSAGES.get("NoLogger"));
        }
        Environment env = this.getEnvironment();
        if (env == null) {
            throw new IllegalStateException(_MESSAGES.get("NoEnvironment"));
        }
        Collection definitions = this.getResourceDefinitions();
        Iterator i = definitions.iterator();
        while (i.hasNext()) {
            ResourceDefinition next = (ResourceDefinition)i.next();
            next.setLog(log);
        }
        this._resourceManager = this.createResourceManager();
        this._resourceManager.setEnvironment(env);
        this._resourceManager.addResourceDefinitions(definitions);
        RouterPersistence persistence = this.getPersistence();
        if (persistence != null) {
            persistence.setResourceManager(this._resourceManager);
            persistence.reload();
            this._resourceManager.addListener(persistence);
        }
        this._resourceManager.initialize();
        this.getLog().info(_MESSAGES.get("RouterIsInitialized"));
        this._hasBeenInitialized = true;
    }

    public Element invoke(Element soapBody) {
        Resource resource = null;
        try {
            resource = this.getTargetResource();
        }
        catch (SoapFault fault) {
            return fault.toXML();
        }
        return resource.invoke(soapBody);
    }

    public void setEnvironment(Environment environment) {
        if (environment == null) {
            throw new NullPointerException(_MESSAGES.get("NullEnvironment"));
        }
        this._environment = environment;
    }

    public void setLog(Logger log) {
        if (log == null) {
            throw new NullPointerException(_MESSAGES.get("NullLogger"));
        }
        this._log = log;
    }

    public void setPersistence(RouterPersistence persistence) {
        this._persistence = persistence;
    }

    public void setResourceDefinitions(Collection resourceDefinitions) {
        if (resourceDefinitions == null) {
            throw new NullPointerException(_MESSAGES.get("NullResourceDefinitions"));
        }
        this._resourceDefinitions = resourceDefinitions;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        if (resourceManager == null) {
            throw new NullPointerException(_MESSAGES.get("NullResourceManager"));
        }
        this._resourceManager = resourceManager;
    }

    public void shutdown() {
        try {
            this.getResourceManager().shutdown();
        }
        catch (SoapFault error) {
            LoggingUtils.logError(this.getLog(), error);
        }
        this._hasBeenShutdown = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

