/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.routing;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.muse.core.Environment;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.descriptor.PersistenceDefinition;
import org.apache.muse.core.descriptor.ResourceDefinition;
import org.apache.muse.core.descriptor.RouterDefinition;
import org.apache.muse.core.descriptor.SerializerDefinition;
import org.apache.muse.core.platform.osgi.OSGiEnvironment;
import org.apache.muse.core.platform.osgi.OSGiEnvironmentImpl;
import org.apache.muse.core.platform.osgi.ResourceManagementProvider;
import org.apache.muse.core.platform.osgi.descriptor.OSGiDeploymentDescriptor;
import org.apache.muse.core.platform.osgi.internal.OSGiResourceManager;
import org.apache.muse.core.platform.osgi.util.BundleRootHelper;
import org.apache.muse.core.platform.osgi.util.OSGiReflectUtilHelper;
import org.apache.muse.core.routing.ResourceRouter;
import org.apache.muse.core.routing.RouterPersistence;
import org.apache.muse.core.routing.SimpleResourceRouter;
import org.apache.muse.core.serializer.ArraySerializer;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OSGiResourceRouter
extends SimpleResourceRouter
implements BundleListener {
    private static HashMap bundleToDefinitionMap = new HashMap();
    private static HashMap delegateMap = new HashMap();
    private static HashMap deferredResources = new HashMap();
    private static HashMap bundleToContextMap = new HashMap();
    private static HashMap contextToBundleMap = new HashMap();
    private static ResourceManagementProvider provider;
    private static OSGiResourceRouter _router;

    public static OSGiResourceRouter getDefault() {
        return _router;
    }

    protected ResourceManager createResourceManager() {
        OSGiResourceManager manager = new OSGiResourceManager();
        return manager;
    }

    public Bundle getDelegateBundle() {
        Environment env = this.getEnvironment();
        EndpointReference epr = env.getAddressingContext().getToAddress();
        String address = epr.getAddress().toString();
        Iterator keys = contextToBundleMap.keySet().iterator();
        while (keys.hasNext()) {
            String currentKey = (String)keys.next();
            if (!address.endsWith(currentKey)) continue;
            return (Bundle)contextToBundleMap.get(currentKey);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element invoke(Element soapBody) {
        Object resource = null;
        try {
            Bundle bundle = this.getDelegateBundle();
            ResourceRouter delegateRouter = null;
            if (bundle != null) {
                delegateRouter = (ResourceRouter)delegateMap.get(bundle);
            }
            ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(bundle);
            Element element = delegateRouter.invoke(soapBody);
            return element;
        }
        finally {
            ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnvironment(Environment environment) {
        super.setEnvironment(environment);
        if (!deferredResources.isEmpty()) {
            HashMap hashMap = deferredResources;
            synchronized (hashMap) {
                Iterator iter = deferredResources.keySet().iterator();
                while (iter.hasNext()) {
                    Object var8_8;
                    Bundle bundle = (Bundle)iter.next();
                    try {
                        try {
                            String target = (String)bundle.getHeaders().get("MUSE-CONFIG");
                            URL resourceURL = bundle.getResource(target);
                            ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(bundle);
                            OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(bundle);
                            this.addResourceDefinitions(bundle, resourceURL);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            var8_8 = null;
                            ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(null);
                            OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(null);
                            continue;
                        }
                        var8_8 = null;
                        ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(null);
                        OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(null);
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(null);
                        OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(null);
                        throw throwable;
                    }
                }
                deferredResources.clear();
            }
        }
    }

    public void initialize(BundleContext context) {
        context.addBundleListener((BundleListener)this);
        Bundle[] bundles = context.getBundles();
        OSGiEnvironmentImpl env = new OSGiEnvironmentImpl(false);
        block3: for (int i = 0; i < bundles.length; ++i) {
            switch (bundles[i].getState()) {
                case 4: 
                case 8: 
                case 32: {
                    String target = (String)bundles[i].getHeaders().get("MUSE-CONFIG");
                    String contextPath = (String)bundles[i].getHeaders().get("MUSE-CONTEXT");
                    if (target == null) continue block3;
                    this.registerBundleResources(bundles[i], contextPath, target);
                    continue block3;
                }
            }
        }
    }

    private Collection getContextPathsForBundle(Bundle bundle, String target) {
        ArrayList<ContextInfo> list = new ArrayList<ContextInfo>();
        OSGiEnvironmentImpl env = new OSGiEnvironmentImpl(false);
        env.setThreadLocalBundle(bundle);
        OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(bundle);
        try {
            Document ddXML = env.getDocument(target);
            OSGiDeploymentDescriptor dd = new OSGiDeploymentDescriptor();
            Collection resourceDefs = dd.loadContextPaths(ddXML, env);
            Iterator paths = resourceDefs.iterator();
            String contextPath = (String)bundle.getHeaders().get("MUSE-CONTEXT");
            while (paths.hasNext()) {
                String context = (String)paths.next();
                String wsdlPath = dd.getWsdlPathForContext(ddXML, context);
                contextToBundleMap.put(contextPath + "/services/" + context, bundle);
                list.add(new ContextInfo(context, wsdlPath));
            }
            bundleToContextMap.put(bundle, new ArrayList(list));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return list;
    }

    private void deployManagementServices(Bundle bundle, String contextName, String target) {
        try {
            provider.intializeContext(bundle, contextName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collection contextPaths = this.getContextPathsForBundle(bundle, target);
        Iterator i = contextPaths.iterator();
        while (i.hasNext()) {
            ContextInfo info = (ContextInfo)i.next();
            String path = info.getContextPath();
            String wsdl = info.getWsdlPath();
            String trimmedPath = path;
            if (trimmedPath.startsWith("/")) {
                trimmedPath = trimmedPath.substring(1);
            }
            try {
                provider.deployManagementService(bundle, contextName, trimmedPath, wsdl);
                BundleRootHelper.registerContext(bundle, contextName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachManagementProvider(ResourceManagementProvider provider) {
        OSGiResourceRouter.provider = provider;
        HashMap hashMap = deferredResources;
        synchronized (hashMap) {
            Iterator i = deferredResources.keySet().iterator();
            while (i.hasNext()) {
                Bundle bundle = (Bundle)i.next();
                Boolean resource = (Boolean)deferredResources.get(bundle);
                if (resource == null || !resource.booleanValue()) continue;
                String target = (String)bundle.getHeaders().get("MUSE-CONFIG");
                String contextPath = (String)bundle.getHeaders().get("MUSE-CONTEXT");
                this.deployManagementServices(bundle, contextPath, target);
                deferredResources.put(bundle, Boolean.FALSE);
            }
        }
    }

    public void releaseManagementProvider() {
        provider = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResourceDefinitions(Bundle bundle, Collection definitions) {
        if (definitions.isEmpty()) {
            return;
        }
        HashMap hashMap = bundleToDefinitionMap;
        synchronized (hashMap) {
            bundleToDefinitionMap.put(bundle, definitions);
        }
    }

    public Document getDocument(Bundle bundle, URL resourceConfig) {
        try {
            return XmlUtils.createDocument(resourceConfig.openStream());
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deferBundleResources(Bundle bundle, String contextName, String target) {
        HashMap hashMap = deferredResources;
        synchronized (hashMap) {
            if (provider != null) {
                if (Boolean.TRUE.equals(deferredResources.get(bundle))) {
                    this.deployManagementServices(bundle, contextName, target);
                    deferredResources.put(bundle, Boolean.FALSE);
                }
            } else {
                deferredResources.put(bundle, Boolean.TRUE);
            }
        }
    }

    protected void addResourceDefinitions(Bundle bundle, URL resourceConfig) {
        OSGiDeploymentDescriptor dd = new OSGiDeploymentDescriptor();
        Document ddXML = this.getDocument(bundle, resourceConfig);
        if (ddXML == null) {
            return;
        }
        try {
            dd.setBundle(bundle);
            dd.load(ddXML, this.getEnvironment());
            Collection serializerDefinitions = dd.getSerializerDefinitions();
            Iterator i = serializerDefinitions.iterator();
            SerializerRegistry registry = SerializerRegistry.getInstance();
            while (i.hasNext()) {
                SerializerDefinition next = (SerializerDefinition)i.next();
                Serializer ser = next.create();
                Class type = ser.getSerializableType();
                Class arrayType = ReflectUtils.getArrayClassFromClass(type);
                ArraySerializer arraySer = new ArraySerializer(arrayType, ser);
                registry.registerSerializer(type, ser);
                registry.registerSerializer(arrayType, arraySer);
            }
            RouterDefinition rd = dd.getRouterDefinition();
            Class delegateRouter = rd.getRouterClass();
            ResourceRouter delegate = null;
            PersistenceDefinition persistenceDef = rd.getPersistenceDefinition();
            if (delegateRouter != null) {
                delegate = rd.newInstance();
                if (persistenceDef != null) {
                    RouterPersistence persistence = (RouterPersistence)persistenceDef.newInstance();
                    delegate.setPersistence(persistence);
                }
                delegate.initialize();
            }
            Collection resourceDefs = dd.getResourceDefinitions();
            this.addResourceDefinitions(bundle, resourceDefs);
            if (delegate != null) {
                delegateMap.put(bundle, delegate);
                Iterator iter = resourceDefs.iterator();
                while (iter.hasNext()) {
                    ResourceDefinition def = (ResourceDefinition)iter.next();
                    String contextPath = (String)bundle.getHeaders().get("MUSE-CONTEXT");
                    def.getContextPath();
                    contextToBundleMap.put(contextPath + "/services/" + def.getContextPath(), bundle);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void registerBundleResources(Bundle bundle, String contextPath, String target) {
        OSGiEnvironment env = (OSGiEnvironment)this.getEnvironment();
        if (env != null) {
            URL resourceURL = bundle.getResource(target);
            try {
                try {
                    env.setThreadLocalBundle(bundle);
                    OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(bundle);
                    this.addResourceDefinitions(bundle, resourceURL);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Object var8_7 = null;
                    ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(null);
                    OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(null);
                }
                Object var8_6 = null;
                ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(null);
                OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(null);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(null);
                OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(null);
                throw throwable;
            }
        } else {
            this.deferBundleResources(bundle, contextPath, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegateBundle(Bundle bundle, String contextPath, String context) {
        HashMap hashMap = contextToBundleMap;
        synchronized (hashMap) {
            contextToBundleMap.put(contextPath + "/services/" + context, bundle);
        }
    }

    protected void removeBundleResources(Bundle bundle) {
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                break;
            }
            case 32: {
                String target = (String)event.getBundle().getHeaders().get("MUSE-CONFIG");
                String contextPath = (String)event.getBundle().getHeaders().get("MUSE-CONTEXT");
                Bundle bundle = event.getBundle();
                if (target == null) break;
                if (this.getEnvironment() != null) {
                    URL resourceURL = bundle.getResource(target);
                    this.addResourceDefinitions(bundle, resourceURL);
                    break;
                }
                this.registerBundleResources(bundle, contextPath, target);
                break;
            }
            case 128: {
                break;
            }
            case 2: {
                String target = (String)event.getBundle().getHeaders().get("MUSE-CONFIG");
                String contextPath = (String)event.getBundle().getHeaders().get("MUSE-CONTEXT");
                Bundle bundle = event.getBundle();
                if (target == null) break;
                if (this.getEnvironment() != null) {
                    ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(event.getBundle());
                    URL resourceURL = bundle.getResource(target);
                    this.addResourceDefinitions(bundle, resourceURL);
                    ((OSGiEnvironment)this.getEnvironment()).setThreadLocalBundle(null);
                    break;
                }
                this.registerBundleResources(bundle, contextPath, target);
                break;
            }
            case 256: {
                break;
            }
            case 4: {
                this.removeBundleResources(event.getBundle());
                break;
            }
            case 16: {
                break;
            }
            case 64: {
                break;
            }
            case 8: {
                break;
            }
        }
    }

    static {
        _router = new OSGiResourceRouter();
    }

    private class ContextInfo {
        private String contextPath;
        private String wsdlPath;

        public ContextInfo(String contextPath, String wsdlPath) {
            this.contextPath = contextPath;
            this.wsdlPath = wsdlPath;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        private String getWsdlPath() {
            return this.wsdlPath;
        }
    }
}

