/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.core.descriptor.DeploymentDescriptor;
import org.apache.muse.core.descriptor.DescriptorConstants;
import org.apache.muse.core.descriptor.PersistenceDefinition;
import org.apache.muse.core.descriptor.ResourceDefinition;
import org.apache.muse.core.descriptor.ResourceDescriptor;
import org.apache.muse.core.descriptor.RouterDefinition;
import org.apache.muse.core.descriptor.RouterDescriptor;
import org.apache.muse.core.descriptor.SerializerDefinition;
import org.apache.muse.core.descriptor.SerializerDescriptor;
import org.apache.muse.core.descriptor.SimpleSerializerDescriptor;
import org.apache.muse.core.platform.osgi.descriptor.OSGiResourceDescriptor;
import org.apache.muse.core.platform.osgi.descriptor.OSGiRouterDescriptor;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OSGiDeploymentDescriptor
implements DeploymentDescriptor {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$descriptor$SimpleDeploymentDescriptor == null ? (class$org$apache$muse$core$descriptor$SimpleDeploymentDescriptor = OSGiDeploymentDescriptor.class$("org.apache.muse.core.descriptor.SimpleDeploymentDescriptor")) : class$org$apache$muse$core$descriptor$SimpleDeploymentDescriptor);
    private Collection _resourceDefinitions = null;
    private static RouterDefinition _routerDefinition = null;
    private RouterDefinition _localRouterDefinition = null;
    private Collection _serializerDefinitions = null;
    private PersistenceDefinition _localPersistenceDefinition;
    protected Bundle bundle;
    static /* synthetic */ Class class$org$apache$muse$core$descriptor$SimpleDeploymentDescriptor;

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Collection loadContextPaths(Document xml, Environment env) throws SoapFault {
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullDescriptorDocument"));
        }
        Element root = XmlUtils.getElement(xml, DescriptorConstants.MUSE_QNAME);
        Element[] resourceXML = XmlUtils.getElements(root, DescriptorConstants.RESOURCE_TYPE_QNAME);
        ArrayList<String> contextPaths = new ArrayList<String>(resourceXML.length);
        QName qname = DescriptorConstants.CONTEXT_PATH_QNAME;
        for (int n = 0; n < resourceXML.length; ++n) {
            String path = XmlUtils.getElementText(resourceXML[n], qname);
            if (path == null) continue;
            contextPaths.add(path);
        }
        return contextPaths;
    }

    public String getWsdlPathForContext(Document xml, String context) throws SoapFault {
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullDescriptorDocument"));
        }
        if (context == null) {
            return null;
        }
        Element root = XmlUtils.getElement(xml, DescriptorConstants.MUSE_QNAME);
        Element[] resourceXML = XmlUtils.getElements(root, DescriptorConstants.RESOURCE_TYPE_QNAME);
        if (resourceXML == null) {
            return null;
        }
        QName qname = DescriptorConstants.CONTEXT_PATH_QNAME;
        for (int i = 0; i < resourceXML.length; ++i) {
            String path = XmlUtils.getElementText(resourceXML[i], qname);
            if (!context.equals(path)) continue;
            Element wsdlElement = XmlUtils.getElement(resourceXML[i], DescriptorConstants.WSDL_QNAME);
            if (wsdlElement == null) break;
            return XmlUtils.getElementText(wsdlElement, DescriptorConstants.WSDL_FILE_QNAME);
        }
        return null;
    }

    public void load(Document xml, Environment environment) throws SoapFault {
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullDescriptorDocument"));
        }
        Element root = XmlUtils.getElement(xml, DescriptorConstants.MUSE_QNAME);
        this._serializerDefinitions = this.createSerializerDefinitions(root, environment);
        this._localRouterDefinition = _routerDefinition == null ? (_routerDefinition = this.createRouterDefinition(root, environment)) : this.createRouterDefinition(root, environment);
        this._resourceDefinitions = this.createResourceDefinitions(root, environment);
        if (this._localRouterDefinition != null) {
            this._localRouterDefinition.setResourceDefinitions(this._resourceDefinitions);
        }
    }

    protected Collection createResourceDefinitions(Element xml, Environment env) throws SoapFault {
        Element[] resourceXML = XmlUtils.getElements(xml, DescriptorConstants.RESOURCE_TYPE_QNAME);
        ArrayList<ResourceDefinition> definitions = new ArrayList<ResourceDefinition>(resourceXML.length);
        for (int n = 0; n < resourceXML.length; ++n) {
            OSGiResourceDescriptor rd = (OSGiResourceDescriptor)this.createResourceDescriptor();
            rd.setBundle(this.bundle);
            rd.load(resourceXML[n], env);
            ResourceDefinition definition = rd.getResourceDefinition();
            definitions.add(definition);
        }
        return definitions;
    }

    protected ResourceDescriptor createResourceDescriptor() {
        return new OSGiResourceDescriptor();
    }

    protected RouterDescriptor createRouterDescriptor() {
        return new OSGiRouterDescriptor();
    }

    protected RouterDefinition createRouterDefinition(Element xml, Environment env) throws SoapFault {
        Element routerXML = XmlUtils.getElement(xml, DescriptorConstants.ROUTER_QNAME);
        RouterDescriptor rd = this.createRouterDescriptor();
        rd.load(routerXML, env);
        return rd.getRouterDefinition();
    }

    protected SerializerDescriptor createSerializerDescriptor() {
        return new SimpleSerializerDescriptor();
    }

    public Collection createSerializerDefinitions(Element xml, Environment env) throws SoapFault {
        QName qname = DescriptorConstants.CUSTOM_SERIALIZER_QNAME;
        Element[] serializerXML = XmlUtils.getElements(xml, qname);
        ArrayList<SerializerDefinition> definitions = new ArrayList<SerializerDefinition>(serializerXML.length);
        for (int n = 0; n < serializerXML.length; ++n) {
            SerializerDescriptor sd = this.createSerializerDescriptor();
            sd.load(serializerXML[n], env);
            SerializerDefinition definition = sd.getSerializerDefinition();
            definitions.add(definition);
        }
        return definitions;
    }

    public Collection getSerializerDefinitions() {
        return this._serializerDefinitions;
    }

    public Collection getResourceDefinitions() {
        return this._resourceDefinitions;
    }

    public RouterDefinition getRouterDefinition() {
        return this._localRouterDefinition;
    }

    public void setSerializerDefinitions(Collection definitions) {
        this._serializerDefinitions = definitions;
    }

    public void setResourceDefinitions(Collection definitions) {
        this._resourceDefinitions = definitions;
    }

    public void setRouterDefinition(RouterDefinition definition) {
        this._localRouterDefinition = definition;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        throw new UnsupportedOperationException("Use SimpleDeploymentDescriptor for descriptor serialization.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

