/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.descriptor;

import java.io.File;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.core.descriptor.DescriptorConstants;
import org.apache.muse.core.descriptor.InitParamDescriptor;
import org.apache.muse.core.descriptor.LoggingConfig;
import org.apache.muse.core.descriptor.PersistenceDefinition;
import org.apache.muse.core.descriptor.PersistenceDescriptor;
import org.apache.muse.core.descriptor.RouterDefinition;
import org.apache.muse.core.descriptor.RouterDescriptor;
import org.apache.muse.core.descriptor.RouterPersistenceDescriptor;
import org.apache.muse.core.descriptor.SimpleInitParamDescriptor;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleRouterDescriptor
implements RouterDescriptor {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$descriptor$SimpleRouterDescriptor == null ? (class$org$apache$muse$core$descriptor$SimpleRouterDescriptor = SimpleRouterDescriptor.class$("org.apache.muse.core.descriptor.SimpleRouterDescriptor")) : class$org$apache$muse$core$descriptor$SimpleRouterDescriptor);
    private RouterDefinition _definition = null;
    static /* synthetic */ Class class$org$apache$muse$core$descriptor$SimpleRouterDescriptor;
    static /* synthetic */ Class class$org$apache$muse$core$routing$ResourceRouter;

    protected InitParamDescriptor createInitParamDescriptor() {
        return new SimpleInitParamDescriptor();
    }

    protected File createLogFile(Element logging, Environment env) {
        QName qname = DescriptorConstants.LOG_FILE_QNAME;
        String location = XmlUtils.getElementText(logging, qname);
        return new File(env.getRealDirectory(), location);
    }

    protected LoggingConfig createLogging(Element xml, Environment env) {
        QName qname = DescriptorConstants.LOGGING_QNAME;
        Element loggingXML = XmlUtils.getElement(xml, qname);
        LoggingConfig logging = this.createLoggingConfig();
        File file = this.createLogFile(loggingXML, env);
        logging.setLogFile(file);
        Level level = this.createLogLevel(loggingXML);
        logging.setLogLevel(level);
        return logging;
    }

    protected LoggingConfig createLoggingConfig() {
        return new LoggingConfig();
    }

    protected Level createLogLevel(Element logging) {
        QName qname = DescriptorConstants.LOG_LEVEL_QNAME;
        String levelString = XmlUtils.getElementText(logging, qname);
        if (levelString == null) {
            return Level.INFO;
        }
        return Level.parse(levelString.trim());
    }

    protected PersistenceDefinition createPersistence(Element xml, Environment env) throws SoapFault {
        Element persistenceXML = XmlUtils.getElement(xml, DescriptorConstants.PERSISTENCE_QNAME);
        if (persistenceXML == null) {
            return null;
        }
        PersistenceDescriptor desc = this.createPersistenceDescriptor();
        desc.load(persistenceXML, env);
        return desc.getPersistenceDefinition();
    }

    protected PersistenceDescriptor createPersistenceDescriptor() {
        return new RouterPersistenceDescriptor();
    }

    protected Class createRouterClass(Element xml, Environment env) {
        ClassLoader loader;
        String className;
        Class theClass;
        if (!(class$org$apache$muse$core$routing$ResourceRouter == null ? (class$org$apache$muse$core$routing$ResourceRouter = SimpleRouterDescriptor.class$("org.apache.muse.core.routing.ResourceRouter")) : class$org$apache$muse$core$routing$ResourceRouter).isAssignableFrom(theClass = ReflectUtils.getClass(className = XmlUtils.getElementText(xml, DescriptorConstants.JAVA_ROUTER_QNAME), loader = env.getClassLoader()))) {
            Object[] filler = new Object[]{className, (class$org$apache$muse$core$routing$ResourceRouter == null ? (class$org$apache$muse$core$routing$ResourceRouter = SimpleRouterDescriptor.class$("org.apache.muse.core.routing.ResourceRouter")) : class$org$apache$muse$core$routing$ResourceRouter).getName()};
            String message = _MESSAGES.get("IncorrectRouterRoot", filler);
            throw new RuntimeException(message);
        }
        return theClass;
    }

    public RouterDefinition getRouterDefinition() {
        return this._definition;
    }

    public void load(Element xml, Environment environment) throws SoapFault {
        Class routerClass = this.createRouterClass(xml, environment);
        LoggingConfig logging = this.createLogging(xml, environment);
        PersistenceDefinition persistence = this.createPersistence(xml, environment);
        this._definition = new RouterDefinition();
        this._definition.setEnvironment(environment);
        this._definition.setRouterClass(routerClass);
        this._definition.setLoggingConfig(logging);
        this._definition.setPersistenceDefinition(persistence);
    }

    public void setRouterDefinition(RouterDefinition definition) {
        this._definition = definition;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        RouterDefinition def = this.getRouterDefinition();
        Element root = XmlUtils.createElement(doc, DescriptorConstants.ROUTER_QNAME);
        XmlUtils.setElement(root, DescriptorConstants.JAVA_ROUTER_QNAME, def.getRouterClass().getName());
        LoggingConfig logging = def.getLoggingConfig();
        Element loggingXML = XmlUtils.createElement(doc, DescriptorConstants.LOGGING_QNAME);
        XmlUtils.setElement(loggingXML, DescriptorConstants.LOG_FILE_QNAME, logging.getLogFile());
        XmlUtils.setElement(loggingXML, DescriptorConstants.LOG_LEVEL_QNAME, logging.getLogFile());
        root.appendChild(loggingXML);
        PersistenceDefinition persistence = def.getPersistenceDefinition();
        if (persistence != null) {
            PersistenceDescriptor pd = this.createPersistenceDescriptor();
            pd.setPersistenceDefinition(persistence);
            Element persistenceXML = pd.toXML(doc);
            root.appendChild(persistenceXML);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

