/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.descriptor;

import java.util.Collection;
import java.util.logging.Logger;
import org.apache.muse.core.Environment;
import org.apache.muse.core.descriptor.LoggingConfig;
import org.apache.muse.core.descriptor.PersistenceDefinition;
import org.apache.muse.core.routing.ResourceRouter;
import org.apache.muse.core.routing.RouterPersistence;
import org.apache.muse.util.ReflectUtils;

public class RouterDefinition {
    private Environment _environment = null;
    private LoggingConfig _logging = null;
    private PersistenceDefinition _persistence = null;
    private Collection _resourceDefinitions = null;
    private Class _theClass = null;

    public Environment getEnvironment() {
        return this._environment;
    }

    public LoggingConfig getLoggingConfig() {
        return this._logging;
    }

    public PersistenceDefinition getPersistenceDefinition() {
        return this._persistence;
    }

    public Collection getResourceDefinitions() {
        return this._resourceDefinitions;
    }

    public Class getRouterClass() {
        return this._theClass;
    }

    public ResourceRouter newInstance() {
        Class theClass = this.getRouterClass();
        ResourceRouter router = (ResourceRouter)ReflectUtils.newInstance(theClass);
        Environment env = this.getEnvironment();
        router.setEnvironment(env);
        LoggingConfig logging = this.getLoggingConfig();
        Logger log = logging.newInstance();
        router.setLog(log);
        router.setResourceDefinitions(this.getResourceDefinitions());
        PersistenceDefinition persistenceDef = this.getPersistenceDefinition();
        if (persistenceDef != null) {
            RouterPersistence persistence = (RouterPersistence)persistenceDef.newInstance();
            router.setPersistence(persistence);
        }
        return router;
    }

    public void setEnvironment(Environment environment) {
        this._environment = environment;
    }

    public void setLoggingConfig(LoggingConfig logging) {
        this._logging = logging;
    }

    public void setPersistenceDefinition(PersistenceDefinition persistence) {
        this._persistence = persistence;
    }

    public void setResourceDefinitions(Collection resourceDefinitions) {
        this._resourceDefinitions = resourceDefinitions;
    }

    public void setRouterClass(Class theClass) {
        this._theClass = theClass;
    }
}

