/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.muse.core.Environment;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.ResourceManagerListener;
import org.apache.muse.core.descriptor.CapabilityDefinition;
import org.apache.muse.core.descriptor.ResourceDefinition;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;

public class SimpleResourceManager
implements ResourceManager {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$SimpleResourceManager == null ? (class$org$apache$muse$core$SimpleResourceManager = SimpleResourceManager.class$("org.apache.muse.core.SimpleResourceManager")) : class$org$apache$muse$core$SimpleResourceManager);
    private Map _definitionsByPath = new LinkedHashMap();
    private Environment _environment = null;
    private boolean _hasBeenInitialized = false;
    private boolean _hasBeenShutdown = false;
    private List _listeners = new LinkedList();
    private Map _resources = new HashMap();
    static /* synthetic */ Class class$org$apache$muse$core$SimpleResourceManager;

    public synchronized void addListener(ResourceManagerListener listener) {
        this._listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(EndpointReference epr, Resource resource) throws SoapFault {
        if (resource == null) {
            throw new NullPointerException(_MESSAGES.get("NullResource"));
        }
        SimpleResourceManager simpleResourceManager = this;
        synchronized (simpleResourceManager) {
            if (this._resources.containsKey(epr)) {
                throw new SoapFault(_MESSAGES.get("ResourceEPRExists", new Object[]{epr}));
            }
            this._resources.put(epr, resource);
        }
        Iterator i = this.getListeners().iterator();
        while (i.hasNext()) {
            ResourceManagerListener next = (ResourceManagerListener)i.next();
            next.resourceAdded(epr, resource);
        }
    }

    public void addResourceDefinitions(Collection definitions) {
        if (definitions == null) {
            throw new NullPointerException(_MESSAGES.get("NullFactoryCollection"));
        }
        if (definitions.isEmpty()) {
            throw new IllegalArgumentException(_MESSAGES.get("EmptyFactoryCollection"));
        }
        Iterator i = definitions.iterator();
        while (i.hasNext()) {
            ResourceDefinition definition = (ResourceDefinition)i.next();
            String endpoint = definition.getContextPath();
            if (this._definitionsByPath.containsKey(endpoint)) {
                Object[] filler = new Object[]{endpoint};
                throw new RuntimeException(_MESSAGES.get("ContextPathExists", filler));
            }
            this._definitionsByPath.put(endpoint, definition);
        }
    }

    public Resource createResource(String contextPath) throws SoapFault {
        ResourceDefinition definition = this.getResourceDefinition(contextPath);
        if (definition == null) {
            Object[] filler = new Object[]{contextPath, this._definitionsByPath.keySet()};
            throw new SoapFault(_MESSAGES.get("ContextPathNotFound", filler));
        }
        Resource resource = definition.newInstance();
        resource.setResourceManager(this);
        this.fixContextPath(resource);
        return resource;
    }

    private void fixContextPath(Resource resource) {
        EndpointReference epr = resource.getEndpointReference();
        String address = epr.getAddress().toString();
        int slash = address.lastIndexOf(47);
        StringBuffer buffer = new StringBuffer();
        buffer.append(address.substring(0, slash));
        String contextPath = resource.getContextPath();
        if (contextPath.charAt(0) != '/') {
            buffer.append('/');
        }
        buffer.append(contextPath);
        URI addressWithProperEndpoint = URI.create(buffer.toString());
        epr.setAddress(addressWithProperEndpoint);
    }

    public Environment getEnvironment() {
        return this._environment;
    }

    protected List getListeners() {
        return new LinkedList(this._listeners);
    }

    public synchronized int getNumberOfResources() {
        return this._resources.size();
    }

    public synchronized Resource getResource(EndpointReference epr) {
        if (epr == null) {
            throw new NullPointerException(_MESSAGES.get("NullResourceEPR"));
        }
        return (Resource)this._resources.get(epr);
    }

    public String getResourceContextPath(Class capabilityClass) {
        Collection matches = this.getResourceContextPaths(capabilityClass);
        return matches.isEmpty() ? null : (String)matches.iterator().next();
    }

    public Collection getResourceContextPaths() {
        return this._definitionsByPath.keySet();
    }

    public Collection getResourceContextPaths(Class capabilityClass) {
        if (capabilityClass == null) {
            throw new NullPointerException(_MESSAGES.get("NullClass"));
        }
        Iterator i = this.getResourceContextPaths().iterator();
        LinkedList<String> matches = new LinkedList<String>();
        while (i.hasNext()) {
            String path = (String)i.next();
            ResourceDefinition resource = this.getResourceDefinition(path);
            Iterator j = resource.getCapabilityDefinitions().iterator();
            while (j.hasNext()) {
                CapabilityDefinition capability = (CapabilityDefinition)j.next();
                Class next = capability.getImplementationClass();
                if (!capabilityClass.isAssignableFrom(next)) continue;
                matches.add(resource.getContextPath());
            }
        }
        return matches;
    }

    protected ResourceDefinition getResourceDefinition(String contextPath) {
        if (contextPath == null) {
            throw new NullPointerException(_MESSAGES.get("NullContextPath"));
        }
        Iterator i = this._definitionsByPath.keySet().iterator();
        while (i.hasNext()) {
            String next = (String)i.next();
            if (!contextPath.equals(next)) continue;
            return (ResourceDefinition)this._definitionsByPath.get(next);
        }
        return null;
    }

    public synchronized Iterator getResourceEPRs() {
        HashSet copy = new HashSet(this._resources.keySet());
        return copy.iterator();
    }

    public synchronized Iterator getResourceEPRs(String contextPath) {
        HashSet<EndpointReference> copy = new HashSet<EndpointReference>();
        Iterator i = this._resources.keySet().iterator();
        while (i.hasNext()) {
            EndpointReference next = (EndpointReference)i.next();
            String addressPath = next.getAddress().getRawPath();
            if (!addressPath.endsWith(contextPath)) continue;
            copy.add(next);
        }
        return copy.iterator();
    }

    public boolean hasBeenInitialized() {
        return this._hasBeenInitialized;
    }

    public boolean hasBeenShutdown() {
        return this._hasBeenShutdown;
    }

    public void initialize() throws SoapFault {
        this._hasBeenInitialized = true;
    }

    public boolean isUsingPersistence(String contextPath) {
        return this.getResourceDefinition(contextPath).isUsingPersistence();
    }

    public synchronized void removeListener(ResourceManagerListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(EndpointReference epr) throws SoapFault {
        SimpleResourceManager simpleResourceManager = this;
        synchronized (simpleResourceManager) {
            Resource resource = (Resource)this._resources.remove(epr);
            if (resource == null) {
                Object[] filler = new Object[]{epr};
                throw new SoapFault(_MESSAGES.get("ResourceEPRNotFound", filler));
            }
        }
        Iterator i = this.getListeners().iterator();
        while (i.hasNext()) {
            ResourceManagerListener next = (ResourceManagerListener)i.next();
            next.resourceRemoved(epr);
        }
    }

    public void removeResourceDefinitions(Collection definitions) {
        if (definitions == null) {
            throw new NullPointerException(_MESSAGES.get("NullFactoryCollection"));
        }
        Iterator i = definitions.iterator();
        while (i.hasNext()) {
            ResourceDefinition next = (ResourceDefinition)i.next();
            String path = next.getContextPath();
            this._definitionsByPath.remove(path);
        }
    }

    public void setEnvironment(Environment environment) {
        if (environment == null) {
            throw new NullPointerException(_MESSAGES.get("NullEnvironment"));
        }
        this._environment = environment;
    }

    public void shutdown() throws SoapFault {
        Iterator i = this.getResourceEPRs();
        while (i.hasNext()) {
            Resource next = this.getResource((EndpointReference)i.next());
            next.shutdown();
        }
        this._hasBeenShutdown = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

