/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.util;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.muse.util.ReflectUtilHelper;
import org.apache.muse.util.osgi.CapabilityPair;
import org.apache.muse.util.osgi.ResourceManagementImplementation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class OSGiReflectUtilHelper
implements ReflectUtilHelper,
ServiceListener {
    private ThreadLocal localEnvironmentContext = new ThreadLocal();
    private static OSGiReflectUtilHelper _helper = new OSGiReflectUtilHelper();
    private BundleContext context;
    private HashMap contributorMap = new HashMap();
    private HashMap serviceMap = new HashMap();
    private HashMap spec2BundleMap = new HashMap();
    private HashMap resourceImpl2BundleMap = new HashMap();
    private HashMap capabilityImpl2BundleMap = new HashMap();
    private static final String MANAGEMENT_IMPLEMENTATION_FILTER = "(objectclass=org.apache.muse.util.osgi.ResourceManagementImplementation)";
    static /* synthetic */ Class class$org$apache$muse$core$platform$osgi$util$OSGiReflectUtilHelper;

    public void setThreadLocalBundle(Bundle bundle) {
        this.localEnvironmentContext.set(bundle);
    }

    public Bundle getThreadLocalBundle() {
        return (Bundle)this.localEnvironmentContext.get();
    }

    public static OSGiReflectUtilHelper getDefault() {
        return _helper;
    }

    public void initialize(BundleContext context) {
        this.context = context;
        try {
            context.addServiceListener((ServiceListener)this, MANAGEMENT_IMPLEMENTATION_FILTER);
            ServiceReference[] refs = context.getServiceReferences("org.apache.muse.util.osgi.ResourceManagementImplementation", MANAGEMENT_IMPLEMENTATION_FILTER);
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    ResourceManagementImplementation impl = (ResourceManagementImplementation)context.getService(refs[i]);
                    if (impl == null) continue;
                    this.loadContributions(impl);
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    private OSGiReflectUtilHelper() {
    }

    public boolean exists(String className) {
        Bundle bundle = (Bundle)this.localEnvironmentContext.get();
        if (bundle == null) {
            return false;
        }
        try {
            bundle.loadClass(className);
            return true;
        }
        catch (Throwable t) {
            try {
                (class$org$apache$muse$core$platform$osgi$util$OSGiReflectUtilHelper == null ? (class$org$apache$muse$core$platform$osgi$util$OSGiReflectUtilHelper = OSGiReflectUtilHelper.class$("org.apache.muse.core.platform.osgi.util.OSGiReflectUtilHelper")) : class$org$apache$muse$core$platform$osgi$util$OSGiReflectUtilHelper).getClassLoader().loadClass(className);
                return true;
            }
            catch (Throwable cnfe) {
                return false;
            }
        }
    }

    private Class getClassFromContributions(String className) {
        CapabilityEntry entry;
        Bundle contributionBundle = null;
        contributionBundle = (Bundle)this.resourceImpl2BundleMap.get(className);
        if (contributionBundle == null && (entry = (CapabilityEntry)this.capabilityImpl2BundleMap.get(className)) != null) {
            contributionBundle = entry.bundle;
        }
        if (contributionBundle == null) {
            return null;
        }
        try {
            return contributionBundle.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {}
        finally {
            return null;
        }
    }

    public Class getClass(String className) {
        Bundle bundle = (Bundle)this.localEnvironmentContext.get();
        if (bundle == null) {
            return this.getClassFromContributions(className);
        }
        try {
            return bundle.loadClass(className);
        }
        catch (Throwable t) {
            try {
                return (class$org$apache$muse$core$platform$osgi$util$OSGiReflectUtilHelper == null ? (class$org$apache$muse$core$platform$osgi$util$OSGiReflectUtilHelper = OSGiReflectUtilHelper.class$("org.apache.muse.core.platform.osgi.util.OSGiReflectUtilHelper")) : class$org$apache$muse$core$platform$osgi$util$OSGiReflectUtilHelper).getClassLoader().loadClass(className);
            }
            catch (Throwable cnfe) {
                return this.getClassFromContributions(className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResource(String name) {
        Bundle bundle = null;
        String trimmedName = name;
        HashMap hashMap = this.spec2BundleMap;
        synchronized (hashMap) {
            bundle = (Bundle)this.spec2BundleMap.get(name);
            if (bundle == null && name.lastIndexOf("/") != -1) {
                trimmedName = name.substring(name.lastIndexOf("/") + 1);
                bundle = (Bundle)this.spec2BundleMap.get(trimmedName);
            }
        }
        if (bundle != null) {
            try {
                URL url = bundle.getResource("/" + trimmedName);
                if (url != null) {
                    return url.openStream();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContributions(ResourceManagementImplementation impl) {
        int i;
        HashMap hashMap;
        Bundle bundle = impl.getBundle();
        String implName = impl.getImplementationName();
        String[] resourceImplNames = impl.getResourceImplementationNames();
        String[] specNames = impl.getResourceSpecNames();
        CapabilityPair[] capabilities = impl.getResourceCapabilityMappings();
        if (resourceImplNames != null) {
            hashMap = this.resourceImpl2BundleMap;
            synchronized (hashMap) {
                for (i = 0; i < resourceImplNames.length; ++i) {
                    this.resourceImpl2BundleMap.put(resourceImplNames[i], bundle);
                }
            }
        }
        if (specNames != null) {
            hashMap = this.spec2BundleMap;
            synchronized (hashMap) {
                for (i = 0; i < specNames.length; ++i) {
                    this.spec2BundleMap.put(specNames[i], bundle);
                }
            }
        }
        if (capabilities != null) {
            hashMap = this.capabilityImpl2BundleMap;
            synchronized (hashMap) {
                for (i = 0; i < capabilities.length; ++i) {
                    String uri = capabilities[i].capabilityURI;
                    String capImpl = capabilities[i].capabilityImplementation;
                    CapabilityEntry entry = new CapabilityEntry(uri, capImpl, bundle);
                    this.capabilityImpl2BundleMap.put(capImpl, entry);
                }
            }
        }
    }

    public synchronized void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        ResourceManagementImplementation impl = (ResourceManagementImplementation)this.context.getService(ref);
        String name = impl.getImplementationName();
        switch (event.getType()) {
            case 1: {
                if (this.contributorMap.get(name) != null) break;
                this.contributorMap.put(name, impl);
                this.serviceMap.put(ref, name);
                this.loadContributions(impl);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                if (this.serviceMap.get(ref) == null) break;
                this.contributorMap.remove(this.serviceMap.get(ref));
                this.serviceMap.remove(ref);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CapabilityEntry {
        public String uri;
        public String implName;
        public Bundle bundle;

        public CapabilityEntry(String uri, String implName, Bundle bundle) {
            this.uri = uri;
            this.implName = implName;
            this.bundle = bundle;
        }
    }
}

