/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.descriptor;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.core.descriptor.CapabilityDescriptor;
import org.apache.muse.core.descriptor.DescriptorConstants;
import org.apache.muse.core.descriptor.ResourceDefinition;
import org.apache.muse.core.descriptor.SimpleResourceDescriptor;
import org.apache.muse.core.descriptor.WsdlConfig;
import org.apache.muse.core.platform.osgi.descriptor.OSGiCapabilityDescriptor;
import org.apache.muse.core.platform.osgi.descriptor.OSGiResourceDefinition;
import org.apache.muse.core.platform.osgi.util.OSGiReflectUtilHelper;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class OSGiResourceDescriptor
extends SimpleResourceDescriptor {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$core$descriptor$SimpleResourceDescriptor == null ? (class$org$apache$muse$core$descriptor$SimpleResourceDescriptor = OSGiResourceDescriptor.class$("org.apache.muse.core.descriptor.SimpleResourceDescriptor")) : class$org$apache$muse$core$descriptor$SimpleResourceDescriptor));
    protected Bundle bundle;
    static /* synthetic */ Class class$org$apache$muse$core$descriptor$SimpleResourceDescriptor;
    static /* synthetic */ Class class$org$apache$muse$core$Resource;

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    protected Class createResourceClass(Element xml, Environment env) {
        QName qname = DescriptorConstants.JAVA_RESOURCE_QNAME;
        String className = XmlUtils.getElementText((Node)xml, (QName)qname);
        if (className == null) {
            throw new RuntimeException(_MESSAGES.get("NullJavaBase"));
        }
        ClassLoader loader = env.getClassLoader();
        Class resourceClass = null;
        if (this.bundle == null) {
            loader = env.getClassLoader();
            resourceClass = ReflectUtils.getClass((String)className, (ClassLoader)loader);
        } else {
            try {
                resourceClass = ReflectUtils.getClass((String)className, (ClassLoader)loader);
                if (resourceClass == null) {
                    resourceClass = this.bundle.loadClass(className);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class Not Found " + className);
            }
        }
        if (!(class$org$apache$muse$core$Resource == null ? (class$org$apache$muse$core$Resource = OSGiResourceDescriptor.class$("org.apache.muse.core.Resource")) : class$org$apache$muse$core$Resource).isAssignableFrom(resourceClass)) {
            Object[] filler = new Object[]{className, (class$org$apache$muse$core$Resource == null ? (class$org$apache$muse$core$Resource = OSGiResourceDescriptor.class$("org.apache.muse.core.Resource")) : class$org$apache$muse$core$Resource).getName()};
            String message = _MESSAGES.get("IncorrectResourceRoot", filler);
            throw new RuntimeException(message);
        }
        return resourceClass;
    }

    protected Map getWsdlOperations(Document wsdlDoc, WsdlConfig wsdlConfig, Environment env) {
        String wsdlPath = wsdlConfig.getWsdlPath();
        String absolutePath = env.getRealDirectory().getAbsolutePath();
        if (wsdlPath.charAt(0) != '/') {
            absolutePath = absolutePath + '/';
        }
        absolutePath = absolutePath + wsdlPath;
        File wsdlFile = new File(absolutePath);
        File wsdlDir = wsdlFile.getParentFile();
        Definition def = null;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            OSGiWsdlLocator locator = new OSGiWsdlLocator(this.bundle, wsdlConfig);
            reader.setFeature("javax.wsdl.verbose", false);
            def = reader.readWSDL((WSDLLocator)locator);
        }
        catch (Exception error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        QName portTypeName = wsdlConfig.getWsdlPortType();
        PortType portType = def.getPortType(portTypeName);
        if (portType == null) {
            throw new RuntimeException("No port type of name " + portType);
        }
        List ops = portType.getOperations();
        Iterator i = ops.iterator();
        HashMap<String, Operation> opsByAction = new HashMap<String, Operation>();
        while (i.hasNext()) {
            Operation next = (Operation)i.next();
            String action = WsdlUtils.getAction((Operation)next);
            opsByAction.put(action, next);
        }
        return opsByAction;
    }

    protected CapabilityDescriptor createCapabilityDescriptor() {
        return new OSGiCapabilityDescriptor(this.bundle);
    }

    protected ResourceDefinition createResourceDefinition() {
        return new OSGiResourceDefinition(this.bundle);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class OSGiWsdlLocator
    implements WSDLLocator {
        private Bundle bundle;
        private WsdlConfig wsdlConfig;
        private String baseURI = "";
        private String lastPath = "";

        public OSGiWsdlLocator(Bundle bundle, WsdlConfig wsdlConfig) {
            this.bundle = bundle;
            this.wsdlConfig = wsdlConfig;
        }

        public InputSource getBaseInputSource() {
            String path = this.wsdlConfig.getWsdlPath();
            URL url = this.bundle.getResource(path);
            InputStream stream = null;
            if (url == null) {
                stream = OSGiReflectUtilHelper.getDefault().getResource(path);
            }
            try {
                if (stream == null) {
                    stream = url.openStream();
                }
            }
            catch (Throwable t) {
                return null;
            }
            if (stream != null) {
                return new InputSource(stream);
            }
            return null;
        }

        public String getBaseURI() {
            if (this.wsdlConfig.getWsdlPath().startsWith("/OSGI-INF/wsdl")) {
                this.baseURI = "/OSGI-INF/wsdl";
            }
            if (this.wsdlConfig.getWsdlPath().startsWith("/wsdl")) {
                this.baseURI = "/wsdl";
            }
            this.baseURI = "";
            return this.baseURI;
        }

        public InputSource getImportInputSource(String base, String path) {
            this.lastPath = path;
            String fullPath = path;
            if (base != null) {
                fullPath = base + "/" + path;
            }
            URL url = this.bundle.getResource(fullPath);
            InputStream stream = null;
            if (url == null) {
                stream = OSGiReflectUtilHelper.getDefault().getResource(fullPath);
            }
            try {
                if (stream == null) {
                    stream = url.openStream();
                }
                this.lastPath = fullPath;
            }
            catch (Throwable t) {
                return null;
            }
            if (stream != null) {
                return new InputSource(stream);
            }
            return null;
        }

        public String getLatestImportURI() {
            return this.lastPath;
        }

        public void close() {
        }
    }
}

