/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.audit.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.audit.AbstractAuditor;
import org.apache.servicemix.jbi.audit.AuditorException;
import org.apache.servicemix.jbi.audit.file.TeeInputStream;
import org.apache.servicemix.jbi.event.ExchangeEvent;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.util.MessageUtil;

public class FileAuditor
extends AbstractAuditor {
    private static final Log LOG = LogFactory.getLog(FileAuditor.class);
    private File directory;

    public void setDirectory(File directory) {
        if (!directory.exists()) {
            LOG.info((Object)("Creating directory " + directory));
            directory.mkdirs();
        }
        this.directory = directory;
    }

    public void exchangeSent(ExchangeEvent event) {
        try {
            MessageExchange exchange = event.getExchange();
            if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                OutputStream os = this.getOutputStream(exchange);
                NormalizedMessage in = exchange.getMessage("in");
                if (StreamSource.class.isAssignableFrom(in.getContent().getClass())) {
                    StreamSource original = (StreamSource)exchange.getMessage("in").getContent();
                    TeeInputStream tis = new TeeInputStream(original.getInputStream(), os);
                    exchange.getMessage("in").setContent((Source)new StreamSource(tis));
                } else {
                    MessageUtil.enableContentRereadability((NormalizedMessage)in);
                    SourceTransformer transformer = new SourceTransformer();
                    transformer.toResult(in.getContent(), (Result)new StreamResult(os));
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)String.format("Error occurred while storing message %s", event.getExchange().getExchangeId()), (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error((Object)String.format("Error occurred while storing message %s", event.getExchange().getExchangeId()), (Throwable)e);
        }
        catch (MessagingException e) {
            LOG.error((Object)String.format("Error occurred while storing message %s", event.getExchange().getExchangeId()), (Throwable)e);
        }
    }

    private OutputStream getOutputStream(MessageExchange exchange) throws FileNotFoundException {
        String name = this.getNameForId(exchange.getExchangeId());
        return new BufferedOutputStream(new FileOutputStream(new File(this.directory, name)));
    }

    private String getNameForId(String id) {
        return id.replaceAll("[:\\.]", "_");
    }

    public int deleteExchangesByIds(String[] ids) throws AuditorException {
        int count = 0;
        for (String id : ids) {
            File file = new File(this.directory, this.getNameForId(id));
            if (!file.delete()) continue;
            ++count;
        }
        return count;
    }

    public int getExchangeCount() throws AuditorException {
        return this.directory.listFiles().length;
    }

    public String[] getExchangeIdsByRange(int fromIndex, int toIndex) throws AuditorException {
        throw new AuditorException("getExchangeIdsByRange currently unsupported by FileAuditor");
    }

    public MessageExchange[] getExchangesByIds(String[] ids) throws AuditorException {
        throw new AuditorException("getExchangeByIds currently unsupported by FileAuditor");
    }

    public String getDescription() {
        return "A file-based auditor implementation: archives files to a specified target directory";
    }
}

