/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow;

import java.util.Timer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.beanflow.Activity;
import org.apache.servicemix.beanflow.JoinAll;
import org.apache.servicemix.beanflow.JoinSupport;
import org.apache.servicemix.beanflow.TimeoutActivity;
import org.apache.servicemix.beanflow.support.EnumHelper;
import org.apache.servicemix.beanflow.support.Interpreter;
import org.apache.servicemix.beanflow.support.ReflectionInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workflow<T>
extends JoinSupport {
    private static final Log log = LogFactory.getLog(Workflow.class);
    private Executor executor;
    private Interpreter interpreter;
    private Timer timer = new Timer();
    private AtomicBoolean suspended = new AtomicBoolean();
    private BlockingQueue<T> queue = new LinkedBlockingQueue<T>();

    public Workflow(Class<T> enumType) {
        this(Workflow.getFirstStep(enumType));
    }

    public Workflow(T firstStep) {
        this(Executors.newSingleThreadExecutor(), firstStep);
    }

    public Workflow(Executor executor, T firstStep) {
        this(executor, new ReflectionInterpreter(), firstStep);
    }

    public Workflow(Executor executor, Interpreter interpreter, T firstStep) {
        this.executor = executor;
        this.interpreter = interpreter;
        if (firstStep instanceof Enum) {
            this.validateStepsExist(firstStep.getClass());
        }
        this.addStep(firstStep);
    }

    public T getNextStep() {
        return (T)this.queue.peek();
    }

    public void addStep(T stepName) {
        this.suspended.set(false);
        this.queue.add(stepName);
        this.executor.execute(this);
    }

    @Override
    public void run() {
        while (!this.isStopped()) {
            try {
                Object stepToExecute = this.queue.poll();
                if (stepToExecute == null) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("About to execute step: " + stepToExecute));
                }
                this.interpreter.executeStep(stepToExecute, this);
            }
            catch (RuntimeException e) {
                log.warn((Object)("Caught: " + e), (Throwable)e);
            }
        }
    }

    public void fork(TimeoutActivity ... activities) {
        for (TimeoutActivity activity : activities) {
            activity.start();
        }
    }

    public void fork(long timeout, TimeoutActivity ... activities) {
        for (TimeoutActivity activity : activities) {
            activity.scheduleTimeout(this.timer, timeout);
            activity.start();
        }
    }

    public void joinAll(T joinedStep, long timeout, Activity ... activities) {
        JoinAll joinFlow = new JoinAll(activities);
        this.join(joinFlow, joinedStep, timeout);
    }

    public void join(JoinSupport joinFlow, T joinedStep, long timeout) {
        joinFlow.onStop(this.createGoToStepTask(joinedStep));
        this.fork(timeout, joinFlow);
    }

    public void suspend() {
        this.suspended.set(true);
    }

    public boolean isSuspended() {
        return this.suspended.get();
    }

    public boolean isNextStepAvailable() {
        return !this.queue.isEmpty();
    }

    public Runnable createGoToStepTask(final T joinedStep) {
        return new Runnable(){

            public void run() {
                Workflow.this.addStep(joinedStep);
            }
        };
    }

    public void onStepException(String stepName, Exception e) {
        log.warn((Object)("Step failed: " + stepName + ". Reason: " + e), (Throwable)e);
        this.suspend();
        this.fail("Failed to execute step: " + stepName + ". Reason: " + e, e);
    }

    @Override
    protected void onChildStateChange(int childCount, int stoppedCount, int failedCount) {
    }

    protected void validateStepsExist(Class enumType) {
        Object[] values = null;
        try {
            values = EnumHelper.getEnumValues(enumType);
        }
        catch (Exception e) {
            this.fail("Cannot get the values of the enumeration: " + enumType.getName(), e);
        }
        if (values != null) {
            this.interpreter.validateStepsExist(values, this);
        }
    }

    protected static Object getFirstStep(Class enumType) {
        try {
            Object[] values = EnumHelper.getEnumValues(enumType);
            return values[0];
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find the values for the enumeration: " + enumType.getName() + ". Reason: " + e, e);
        }
    }
}

