/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xbean.kernel.KernelErrorsError;
import org.apache.xbean.kernel.KernelMonitor;
import org.apache.xbean.kernel.ServiceEvent;
import org.apache.xbean.kernel.ServiceMonitor;
import org.apache.xbean.kernel.ServiceName;

public class ServiceMonitorBroadcaster
implements ServiceMonitor {
    private final Map serviceMonitors = new LinkedHashMap();
    private final KernelMonitor kernelMonitor;

    public ServiceMonitorBroadcaster(KernelMonitor kernelMonitor) {
        if (kernelMonitor == null) {
            throw new NullPointerException("kernelMonitor is null");
        }
        this.kernelMonitor = kernelMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceMonitor(ServiceMonitor serviceMonitor, ServiceName serviceName) {
        if (serviceMonitor == null) {
            throw new NullPointerException("serviceMonitor is null");
        }
        Map map = this.serviceMonitors;
        synchronized (map) {
            LinkedHashSet<ServiceMonitor> monitors = (LinkedHashSet<ServiceMonitor>)this.serviceMonitors.get(serviceName);
            if (monitors == null) {
                monitors = new LinkedHashSet<ServiceMonitor>();
                this.serviceMonitors.put(serviceName, monitors);
            }
            monitors.add(serviceMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceMonitor(ServiceMonitor serviceMonitor) {
        if (serviceMonitor == null) {
            throw new NullPointerException("serviceMonitor is null");
        }
        Map map = this.serviceMonitors;
        synchronized (map) {
            Iterator iterator = this.serviceMonitors.values().iterator();
            while (iterator.hasNext()) {
                Set monitors = (Set)iterator.next();
                monitors.remove(serviceMonitor);
                if (!monitors.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getServiceMonitors(ServiceName serviceName) {
        Map map = this.serviceMonitors;
        synchronized (map) {
            Set specificMonitors;
            LinkedHashSet monitors = new LinkedHashSet();
            Set globalMonitors = (Set)this.serviceMonitors.get(null);
            if (globalMonitors != null) {
                monitors.addAll(globalMonitors);
            }
            if ((specificMonitors = (Set)this.serviceMonitors.get(serviceName)) != null) {
                monitors.addAll(specificMonitors);
            }
            return monitors;
        }
    }

    public void serviceRegistered(ServiceEvent serviceEvent) {
        ArrayList errors = new ArrayList();
        Set serviceMonitors = this.getServiceMonitors(serviceEvent.getServiceName());
        for (ServiceMonitor serviceMonitor : serviceMonitors) {
            try {
                serviceMonitor.serviceRegistered(serviceEvent);
            }
            catch (Throwable e) {
                errors.addAll(this.fireServiceNotificationError(serviceMonitor, serviceEvent, e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    public void serviceStarting(ServiceEvent serviceEvent) {
        ArrayList errors = new ArrayList();
        Set serviceMonitors = this.getServiceMonitors(serviceEvent.getServiceName());
        for (ServiceMonitor serviceMonitor : serviceMonitors) {
            try {
                serviceMonitor.serviceStarting(serviceEvent);
            }
            catch (Throwable e) {
                errors.addAll(this.fireServiceNotificationError(serviceMonitor, serviceEvent, e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    public void serviceWaitingToStart(ServiceEvent serviceEvent) {
        ArrayList errors = new ArrayList();
        Set serviceMonitors = this.getServiceMonitors(serviceEvent.getServiceName());
        for (ServiceMonitor serviceMonitor : serviceMonitors) {
            try {
                serviceMonitor.serviceWaitingToStart(serviceEvent);
            }
            catch (Throwable e) {
                errors.addAll(this.fireServiceNotificationError(serviceMonitor, serviceEvent, e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    public void serviceStartError(ServiceEvent serviceEvent) {
        ArrayList errors = new ArrayList();
        Set serviceMonitors = this.getServiceMonitors(serviceEvent.getServiceName());
        for (ServiceMonitor serviceMonitor : serviceMonitors) {
            try {
                serviceMonitor.serviceStartError(serviceEvent);
            }
            catch (Throwable e) {
                errors.addAll(this.fireServiceNotificationError(serviceMonitor, serviceEvent, e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    public void serviceRunning(ServiceEvent serviceEvent) {
        ArrayList errors = new ArrayList();
        Set serviceMonitors = this.getServiceMonitors(serviceEvent.getServiceName());
        for (ServiceMonitor serviceMonitor : serviceMonitors) {
            try {
                serviceMonitor.serviceRunning(serviceEvent);
            }
            catch (Throwable e) {
                errors.addAll(this.fireServiceNotificationError(serviceMonitor, serviceEvent, e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    public void serviceStopping(ServiceEvent serviceEvent) {
        ArrayList errors = new ArrayList();
        Set serviceMonitors = this.getServiceMonitors(serviceEvent.getServiceName());
        for (ServiceMonitor serviceMonitor : serviceMonitors) {
            try {
                serviceMonitor.serviceStopping(serviceEvent);
            }
            catch (Throwable e) {
                errors.addAll(this.fireServiceNotificationError(serviceMonitor, serviceEvent, e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    public void serviceWaitingToStop(ServiceEvent serviceEvent) {
        ArrayList errors = new ArrayList();
        Set serviceMonitors = this.getServiceMonitors(serviceEvent.getServiceName());
        for (ServiceMonitor serviceMonitor : serviceMonitors) {
            try {
                serviceMonitor.serviceWaitingToStop(serviceEvent);
            }
            catch (Throwable e) {
                errors.addAll(this.fireServiceNotificationError(serviceMonitor, serviceEvent, e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    public void serviceStopError(ServiceEvent serviceEvent) {
        ArrayList errors = new ArrayList();
        Set serviceMonitors = this.getServiceMonitors(serviceEvent.getServiceName());
        for (ServiceMonitor serviceMonitor : serviceMonitors) {
            try {
                serviceMonitor.serviceStopError(serviceEvent);
            }
            catch (Throwable e) {
                errors.addAll(this.fireServiceNotificationError(serviceMonitor, serviceEvent, e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    public void serviceStopped(ServiceEvent serviceEvent) {
        ArrayList errors = new ArrayList();
        Set serviceMonitors = this.getServiceMonitors(serviceEvent.getServiceName());
        for (ServiceMonitor serviceMonitor : serviceMonitors) {
            try {
                serviceMonitor.serviceStopped(serviceEvent);
            }
            catch (Throwable e) {
                errors.addAll(this.fireServiceNotificationError(serviceMonitor, serviceEvent, e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    public void serviceUnregistered(ServiceEvent serviceEvent) {
        ArrayList errors = new ArrayList();
        Set serviceMonitors = this.getServiceMonitors(serviceEvent.getServiceName());
        for (ServiceMonitor serviceMonitor : serviceMonitors) {
            try {
                serviceMonitor.serviceUnregistered(serviceEvent);
            }
            catch (Throwable e) {
                errors.addAll(this.fireServiceNotificationError(serviceMonitor, serviceEvent, e));
            }
        }
        if (!errors.isEmpty()) {
            throw new KernelErrorsError(errors);
        }
    }

    private List fireServiceNotificationError(ServiceMonitor serviceMonitor, ServiceEvent serviceEvent, Throwable throwable) {
        try {
            this.kernelMonitor.serviceNotificationError(serviceMonitor, serviceEvent, throwable);
        }
        catch (RuntimeException ignored) {
        }
        catch (KernelErrorsError e) {
            return e.getErrors();
        }
        catch (Error e) {
            return Collections.singletonList(e);
        }
        return Collections.EMPTY_LIST;
    }
}

