/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import java.util.Collections;
import java.util.Set;
import org.apache.xbean.kernel.ServiceName;

public class UnsatisfiedConditionsException
extends Exception {
    private final ServiceName serviceName;
    private final Set unsatisfiedConditions;

    public UnsatisfiedConditionsException(String message, ServiceName serviceName, Set unsatisfiedConditions) {
        super(message + ": serviceName=" + serviceName + ": unsatisfiedConditions=" + unsatisfiedConditions);
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (unsatisfiedConditions == null) {
            throw new NullPointerException("unsatisfiedConditions is null");
        }
        this.serviceName = serviceName;
        this.unsatisfiedConditions = Collections.unmodifiableSet(unsatisfiedConditions);
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public Set getUnsatisfiedConditions() {
        return this.unsatisfiedConditions;
    }
}

