/*
 * Decompiled with CFR 0.152.
 */
package org.jencks;

import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jencks.DefaultEndpointFactory;
import org.jencks.JCAContainer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JCAConnector
implements InitializingBean,
DisposableBean,
BeanFactoryAware,
BeanNameAware {
    private static final transient Log log = LogFactory.getLog(JCAConnector.class);
    private ActivationSpec activationSpec;
    private BootstrapContext bootstrapContext;
    private MessageEndpointFactory endpointFactory;
    private ResourceAdapter resourceAdapter;
    private String ref;
    private TransactionManager transactionManager;
    private BeanFactory beanFactory;
    private String name;
    private JCAContainer jcaContainer;
    private String acknowledgeType = "SESSION_TRANSACTED";

    public JCAConnector() {
    }

    public JCAConnector(BootstrapContext bootstrapContext, ResourceAdapter resourceAdapter) {
        this.bootstrapContext = bootstrapContext;
        this.resourceAdapter = resourceAdapter;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.activationSpec == null) {
            throw new IllegalArgumentException("activationSpec must be set");
        }
        if (this.resourceAdapter == null) {
            this.resourceAdapter = this.activationSpec.getResourceAdapter();
        }
        if (this.jcaContainer != null) {
            this.start();
        }
    }

    public void destroy() throws Exception {
        if (this.resourceAdapter != null && this.activationSpec != null) {
            this.resourceAdapter.endpointDeactivation(this.endpointFactory, this.activationSpec);
        }
    }

    public void start() throws Exception {
        if (this.resourceAdapter == null && this.jcaContainer != null) {
            this.resourceAdapter = this.jcaContainer.getResourceAdapter();
        }
        if (this.resourceAdapter == null) {
            throw new IllegalArgumentException("resourceAdapter property must be set on the activationSpec object");
        }
        if (this.activationSpec.getResourceAdapter() == null) {
            this.activationSpec.setResourceAdapter(this.resourceAdapter);
        }
        if (this.bootstrapContext == null && this.jcaContainer != null) {
            this.bootstrapContext = this.jcaContainer.getBootstrapContext();
        }
        if (this.bootstrapContext == null) {
            throw new IllegalArgumentException("bootstrapContext must be set");
        }
        if (this.endpointFactory == null) {
            if (this.ref == null) {
                throw new IllegalArgumentException("either the endpointFactory or ref properties must be set");
            }
            DefaultEndpointFactory defaultEF = new DefaultEndpointFactory(this.beanFactory, this.ref);
            defaultEF.setAcknowledgeType(this.acknowledgeType);
            defaultEF.setTransactionManager(this.transactionManager);
            defaultEF.setName(this.name);
            this.endpointFactory = defaultEF;
        }
        log.info((Object)("Activating endpoint for activationSpec: " + this.activationSpec + " using endpointFactory: " + this.endpointFactory));
        this.resourceAdapter.endpointActivation(this.endpointFactory, this.activationSpec);
    }

    public String getName() {
        return this.name;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this.activationSpec = activationSpec;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public MessageEndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public void setEndpointFactory(MessageEndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public JCAContainer getJcaContainer() {
        return this.jcaContainer;
    }

    public void setJcaContainer(JCAContainer jcaConnector) {
        this.jcaContainer = jcaConnector;
    }

    public String getAcknowledgeType() {
        return this.acknowledgeType;
    }

    public void setAcknowledgeType(String acknowledgeTpe) {
        this.acknowledgeType = acknowledgeTpe;
    }
}

