/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tck;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.SpringJBIContainer;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.apache.servicemix.tck.MessageList;
import org.apache.xpath.CachedXPathAPI;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public abstract class SpringTestSupport
extends TestCase {
    protected transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected AbstractXmlApplicationContext context;
    protected SourceTransformer transformer;
    protected int messageCount = 20;
    protected SpringJBIContainer jbi;

    protected void setUp() throws Exception {
        this.transformer = new SourceTransformer();
        this.context = this.createBeanFactory();
        this.jbi = (SpringJBIContainer)this.context.getBean("jbi");
        SpringTestSupport.assertNotNull((String)"JBI Container not found in spring!", (Object)this.jbi);
    }

    protected void tearDown() throws Exception {
        if (this.context != null) {
            this.log.info((Object)"Closing down the spring context");
            this.context.destroy();
        }
    }

    protected Object getBean(String name) {
        Object answer = null;
        if (this.jbi != null) {
            answer = this.jbi.getBean(name);
        }
        if (answer == null) {
            answer = this.context.getBean(name);
        }
        SpringTestSupport.assertNotNull((String)("Could not find object in Spring for key: " + name), (Object)answer);
        return answer;
    }

    protected abstract AbstractXmlApplicationContext createBeanFactory();

    protected String textValueOfXPath(Node node, String xpath) throws TransformerException {
        CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
        NodeIterator iterator = cachedXPathAPI.selectNodeIterator(node, xpath);
        Node root = iterator.nextNode();
        if (root instanceof Element) {
            Element element = (Element)root;
            if (element == null) {
                return "";
            }
            return DOMUtil.getElementText(element);
        }
        if (root != null) {
            return root.getNodeValue();
        }
        return null;
    }

    protected Source getSourceFromClassPath(String fileOnClassPath) {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(fileOnClassPath);
        SpringTestSupport.assertNotNull((String)("Could not find file: " + fileOnClassPath + " on the classpath"), (Object)stream);
        return new StreamSource(stream);
    }

    protected void assertMessagesReceived(MessageList messageList, int count) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException {
        messageList.assertMessagesReceived(count);
        List list = messageList.getMessages();
        int counter = 0;
        for (NormalizedMessage message : list) {
            this.log.info((Object)("Message " + counter++ + " is: " + message));
            this.log.info((Object)this.transformer.contentToString(message));
        }
    }

    protected void assertExchangeWorked(MessageExchange me) throws Exception {
        if (me.getStatus() == ExchangeStatus.ERROR) {
            if (me.getError() != null) {
                throw me.getError();
            }
            SpringTestSupport.fail((String)"Received ERROR status");
        } else if (me.getFault() != null) {
            SpringTestSupport.fail((String)("Received fault: " + new SourceTransformer().toString(me.getFault().getContent())));
        }
    }
}

