/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.util.ByteArrayDataSource;
import org.apache.servicemix.jbi.util.FileUtil;
import org.apache.servicemix.jbi.util.MessageUtil;

public class MessageCopier {
    private boolean copySubject;
    private boolean copyContent;
    private boolean copyProperties;
    private boolean copyAttachments;

    public MessageCopier() {
        this(true, true, true, true);
    }

    public MessageCopier(boolean copySubject, boolean copyContent, boolean copyProperties, boolean copyAttachments) {
        this.copySubject = copySubject;
        this.copyContent = copyContent;
        this.copyProperties = copyProperties;
        this.copyAttachments = copyAttachments;
    }

    public NormalizedMessage copy(NormalizedMessage message) throws MessagingException {
        MessageUtil.NormalizedMessageImpl copy = new MessageUtil.NormalizedMessageImpl();
        if (this.copySubject) {
            MessageCopier.copySubject(message, copy);
        }
        if (this.copyContent) {
            MessageCopier.copyContent(message, copy);
        }
        if (this.copyProperties) {
            MessageCopier.copyProperties(message, copy);
        }
        if (this.copyAttachments) {
            MessageCopier.copyAttachments(message, copy);
        }
        return copy;
    }

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public boolean isCopyContent() {
        return this.copyContent;
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public boolean isCopySubject() {
        return this.copySubject;
    }

    private static void copySubject(NormalizedMessage from, NormalizedMessage to) {
        to.setSecuritySubject(from.getSecuritySubject());
    }

    private static void copyContent(NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        String str = null;
        try {
            str = new SourceTransformer().toString(from.getContent());
        }
        catch (Exception e) {
            throw new MessagingException((Throwable)e);
        }
        if (str != null) {
            to.setContent((Source)new StringSource(str));
        }
    }

    private static void copyProperties(NormalizedMessage from, NormalizedMessage to) {
        for (Object name : from.getPropertyNames()) {
            to.setProperty((String)name, from.getProperty((String)name));
        }
    }

    private static void copyAttachments(NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        for (Object name : from.getAttachmentNames()) {
            DataHandler handler = from.getAttachment((String)name);
            DataSource source = handler.getDataSource();
            if (!(source instanceof ByteArrayDataSource)) {
                DataSource copy = MessageCopier.copyDataSource(source);
                handler = new DataHandler(copy);
            }
            to.addAttachment((String)name, handler);
        }
    }

    private static DataSource copyDataSource(DataSource source) throws MessagingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtil.copyInputStream(source.getInputStream(), baos);
            ByteArrayDataSource bads = new ByteArrayDataSource(baos.toByteArray(), source.getContentType());
            bads.setName(source.getName());
            return bads;
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
    }
}

