/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.util.FileUtil;

public final class FileVersionUtil {
    private static final Log LOG = LogFactory.getLog(FileVersionUtil.class);
    private static final String VERSION_PREFIX = "version_";
    private static final String[] RESERVED = new String[]{"version_"};

    private FileVersionUtil() {
    }

    public static int getLatestVersionNumber(File rootDirectory) {
        int result = -1;
        if (FileVersionUtil.isVersioned(rootDirectory)) {
            File[] files = rootDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                int version = FileVersionUtil.getVersionNumber(files[i].getName());
                if (version <= result) continue;
                result = version;
            }
        }
        return result;
    }

    public static File getLatestVersionDirectory(File rootDirectory) {
        File result = null;
        int highestVersion = -1;
        if (rootDirectory != null && FileVersionUtil.isVersioned(rootDirectory)) {
            File[] files = rootDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                int version = FileVersionUtil.getVersionNumber(files[i].getName());
                if (version <= highestVersion) continue;
                highestVersion = version;
                result = files[i];
            }
        }
        return result;
    }

    public static File createNewVersionDirectory(File rootDirectory) throws IOException {
        File result = FileVersionUtil.getNewVersionDirectory(rootDirectory);
        if (!FileUtil.buildDirectory(result)) {
            throw new IOException("Failed to build version directory: " + result);
        }
        return result;
    }

    public static File getNewVersionDirectory(File rootDirectory) throws IOException {
        String versionDirectoryName;
        File result = null;
        if (FileUtil.buildDirectory(rootDirectory)) {
            versionDirectoryName = VERSION_PREFIX;
            if (FileVersionUtil.isVersioned(rootDirectory)) {
                int versionNumber = FileVersionUtil.getLatestVersionNumber(rootDirectory);
                versionNumber = versionNumber > 0 ? versionNumber + 1 : 1;
                versionDirectoryName = versionDirectoryName + versionNumber;
            } else {
                versionDirectoryName = versionDirectoryName + 1;
            }
        } else {
            throw new IOException("Cannot build parent directory: " + rootDirectory);
        }
        result = FileUtil.getDirectoryPath(rootDirectory, versionDirectoryName);
        return result;
    }

    public static void initializeVersionDirectory(File rootDirectory) throws IOException {
        if (!FileVersionUtil.isVersioned(rootDirectory)) {
            File newRoot = FileVersionUtil.createNewVersionDirectory(rootDirectory);
            File[] files = rootDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (FileVersionUtil.isReserved(files[i].getName())) continue;
                LOG.info((Object)(rootDirectory.getPath() + ": moving non-versioned file " + files[i].getName() + " to " + newRoot.getName()));
                File moveTo = FileUtil.getDirectoryPath(newRoot, files[i].getName());
                FileUtil.moveFile(files[i], moveTo);
            }
        }
    }

    private static boolean isVersioned(File rootDirectory) {
        boolean result = false;
        if (rootDirectory.exists() && rootDirectory.isDirectory()) {
            File[] files = rootDirectory.listFiles();
            boolean bl = result = files == null || files.length == 0;
            if (!result) {
                for (int i = 0; i < files.length; ++i) {
                    if (!FileVersionUtil.isReserved(files[i].getName())) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private static boolean isReserved(String name) {
        boolean result = false;
        if (name != null) {
            for (int i = 0; i < RESERVED.length; ++i) {
                if (!name.startsWith(RESERVED[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static int getVersionNumber(String name) {
        int result = -1;
        if (name != null && name.startsWith(VERSION_PREFIX)) {
            String number = name.substring(VERSION_PREFIX.length());
            result = Integer.parseInt(number);
        }
        return result;
    }
}

