/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.security.acl.impl;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.security.acl.AuthorizationMap;
import org.apache.servicemix.jbi.security.acl.impl.AuthorizationEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthorizationMap
implements AuthorizationMap {
    private AuthorizationEntry defaultEntry;
    private List<AuthorizationEntry> authorizationEntries;

    public DefaultAuthorizationMap() {
    }

    public DefaultAuthorizationMap(List<AuthorizationEntry> authorizationEntries) {
        this.authorizationEntries = authorizationEntries;
    }

    public List<AuthorizationEntry> getAuthorizationEntries() {
        return this.authorizationEntries;
    }

    public void setAuthorizationEntries(List<AuthorizationEntry> authorizationEntries) {
        this.authorizationEntries = authorizationEntries;
    }

    public AuthorizationEntry getDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(AuthorizationEntry defaultEntry) {
        this.defaultEntry = defaultEntry;
    }

    @Override
    public Set<Principal> getAcls(ServiceEndpoint endpoint, QName operation) {
        HashSet<Principal> acls = new HashSet<Principal>();
        if (this.defaultEntry != null) {
            acls.addAll(this.defaultEntry.getAcls());
        }
        for (AuthorizationEntry entry : this.authorizationEntries) {
            if (!this.match(entry, endpoint, operation)) continue;
            if ("add".equalsIgnoreCase(entry.getType())) {
                acls.addAll(entry.getAcls());
                continue;
            }
            if ("set".equalsIgnoreCase(entry.getType())) {
                acls.clear();
                acls.addAll(entry.getAcls());
                continue;
            }
            if (!"rem".equalsIgnoreCase(entry.getType())) continue;
            acls.removeAll(entry.getAcls());
        }
        return acls;
    }

    protected boolean match(AuthorizationEntry entry, ServiceEndpoint endpoint, QName operation) {
        return this.match(entry.getService(), endpoint.getServiceName()) && this.match(entry.getEndpoint(), endpoint.getEndpointName()) && (entry.getOperation() == null || operation == null || this.match(entry.getOperation(), operation));
    }

    private boolean match(QName acl, QName target) {
        return this.match(acl.getNamespaceURI(), target.getNamespaceURI()) && this.match(acl.getLocalPart(), target.getLocalPart());
    }

    private boolean match(String acl, String target) {
        return acl == null || acl.equals("*") || Pattern.matches(acl, target);
    }
}

