/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.security;

import java.security.Principal;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.DefaultBroker;
import org.apache.servicemix.jbi.security.GroupPrincipal;
import org.apache.servicemix.jbi.security.acl.AuthorizationMap;

public class SecuredBroker
extends DefaultBroker {
    private AuthorizationMap authorizationMap;

    public SecuredBroker() {
    }

    public SecuredBroker(AuthorizationMap authorizationMap) {
        this.authorizationMap = authorizationMap;
    }

    public AuthorizationMap getAuthorizationMap() {
        return this.authorizationMap;
    }

    public void setAuthorizationMap(AuthorizationMap authorizationMap) {
        this.authorizationMap = authorizationMap;
    }

    public void sendExchangePacket(MessageExchange me) throws JBIException {
        MessageExchangeImpl exchange = (MessageExchangeImpl)me;
        if (exchange.getRole() == MessageExchange.Role.PROVIDER && exchange.getDestinationId() == null) {
            Set<Principal> acls;
            this.resolveAddress(exchange);
            ServiceEndpoint se = exchange.getEndpoint();
            if (se != null && !(acls = this.authorizationMap.getAcls(se, me.getOperation())).contains(GroupPrincipal.ANY)) {
                Subject subject = exchange.getMessage("in").getSecuritySubject();
                if (subject == null) {
                    throw new SecurityException("User not authenticated");
                }
                acls.retainAll(subject.getPrincipals());
                if (acls.size() == 0) {
                    throw new SecurityException("Endpoint is not authorized for this user");
                }
            }
        }
        super.sendExchangePacket(me);
    }
}

