/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow.jms;

import javax.jbi.JBIException;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.servicemix.jbi.nmr.flow.jms.AbstractJMSFlow;

public class JMSFlow
extends AbstractJMSFlow {
    private PooledConnectionFactory factory;

    protected ConnectionFactory createConnectionFactoryFromUrl(String jmsURL) {
        this.factory = jmsURL != null ? new PooledConnectionFactory(jmsURL) : new PooledConnectionFactory();
        return this.factory;
    }

    protected void onConsumerMonitorMessage(Message advisoryMessage) {
        if (!this.started.get()) {
            return;
        }
        DataStructure obj = ((ActiveMQMessage)advisoryMessage).getDataStructure();
        if (obj instanceof ConsumerInfo) {
            ConsumerInfo info = (ConsumerInfo)obj;
            this.addClusterNode(info.getConsumerId().getConnectionId());
        } else if (obj instanceof RemoveInfo) {
            ConsumerId consumerId = (ConsumerId)((RemoveInfo)obj).getObjectId();
            this.removeClusterNode(consumerId.getConnectionId());
        }
    }

    public void startConsumerMonitor() throws JMSException {
        Session broadcastSession = this.connection.createSession(false, 1);
        Topic broadcastTopic = broadcastSession.createTopic(this.getBroadcastDestinationName());
        ActiveMQTopic advisoryTopic = AdvisorySupport.getConsumerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)broadcastTopic));
        this.monitorMessageConsumer = broadcastSession.createConsumer((Destination)advisoryTopic);
        this.monitorMessageConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                JMSFlow.this.onConsumerMonitorMessage(message);
            }
        });
    }

    public void shutDown() throws JBIException {
        super.shutDown();
        if (this.factory != null) {
            try {
                this.factory.stop();
            }
            catch (Exception e) {
                this.log.warn((Object)("Unable to stop JMS connection pool: " + e), (Throwable)e);
            }
        }
    }
}

