/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.messaging;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.ExchangeTimeoutException;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.event.ExchangeEvent;
import org.apache.servicemix.jbi.event.ExchangeListener;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeFactoryImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;

public class DeliveryChannelImpl
implements DeliveryChannel {
    private static final Log LOG = LogFactory.getLog(DeliveryChannelImpl.class);
    private JBIContainer container;
    private ComponentContextImpl context;
    private ComponentMBeanImpl component;
    private BlockingQueue<MessageExchangeImpl> queue;
    private IdGenerator idGenerator = new IdGenerator();
    private MessageExchangeFactory inboundFactory;
    private int intervalCount;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private Map<Thread, Boolean> waiters = new ConcurrentHashMap<Thread, Boolean>();
    private TransactionManager transactionManager;
    private Map<String, MessageExchangeImpl> exchangesById = new ConcurrentHashMap<String, MessageExchangeImpl>();

    public DeliveryChannelImpl(ComponentMBeanImpl component) {
        this.component = component;
        this.container = component.getContainer();
        this.queue = new ArrayBlockingQueue<MessageExchangeImpl>(component.getInboundQueueCapacity());
        this.transactionManager = (TransactionManager)this.container.getTransactionManager();
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public void close() throws MessagingException {
        if (this.closed.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Closing DeliveryChannel " + this));
            }
            ArrayList pending = new ArrayList(this.queue.size());
            this.queue.drainTo(pending);
            for (MessageExchangeImpl messageExchange : pending) {
                if (messageExchange.getTransactionContext() == null || messageExchange.getMirror().getSyncState() != 1) continue;
                this.notifyExchange(messageExchange.getMirror(), messageExchange.getMirror(), "close");
            }
            Thread[] threads = this.waiters.keySet().toArray(new Thread[this.waiters.size()]);
            for (int i = 0; i < threads.length; ++i) {
                threads[i].interrupt();
            }
            ServiceEndpoint[] endpoints = this.container.getRegistry().getEndpointsForComponent(this.component.getComponentNameSpace());
            for (int i = 0; i < endpoints.length; ++i) {
                try {
                    this.component.getContext().deactivateEndpoint(endpoints[i]);
                    continue;
                }
                catch (JBIException e) {
                    LOG.error((Object)"Error deactivating endpoint", (Throwable)e);
                }
            }
        }
    }

    protected void checkNotClosed() throws MessagingException {
        if (this.closed.get()) {
            throw new MessagingException(this + " has been closed.");
        }
    }

    public MessageExchangeFactory createExchangeFactory() {
        MessageExchangeFactoryImpl result = this.createMessageExchangeFactory();
        result.setContext(this.context);
        ActivationSpec activationSpec = this.context.getActivationSpec();
        if (activationSpec != null) {
            String endpointName;
            QName operationName;
            QName interfaceName;
            String componentName = this.context.getComponentNameSpace().getName();
            QName serviceName = activationSpec.getDestinationService();
            if (serviceName != null) {
                result.setServiceName(serviceName);
                LOG.debug((Object)("default destination serviceName for " + componentName + " = " + serviceName));
            }
            if ((interfaceName = activationSpec.getDestinationInterface()) != null) {
                result.setInterfaceName(interfaceName);
                LOG.debug((Object)("default destination interfaceName for " + componentName + " = " + interfaceName));
            }
            if ((operationName = activationSpec.getDestinationOperation()) != null) {
                result.setOperationName(operationName);
                LOG.debug((Object)("default destination operationName for " + componentName + " = " + operationName));
            }
            if ((endpointName = activationSpec.getDestinationEndpoint()) != null) {
                boolean endpointSet = false;
                LOG.debug((Object)("default destination endpointName for " + componentName + " = " + endpointName));
                if (serviceName != null && endpointName != null) {
                    endpointName = endpointName.trim();
                    ServiceEndpoint endpoint = this.container.getRegistry().getEndpoint(serviceName, endpointName);
                    if (endpoint != null) {
                        result.setEndpoint(endpoint);
                        LOG.info((Object)("Set default destination endpoint for " + componentName + " to " + endpoint));
                        endpointSet = true;
                    }
                }
                if (!endpointSet) {
                    LOG.warn((Object)("Could not find destination endpoint for " + componentName + " service(" + serviceName + ") with endpointName " + endpointName));
                }
            }
        }
        return result;
    }

    public MessageExchangeFactory createExchangeFactory(QName interfaceName) {
        MessageExchangeFactoryImpl result = this.createMessageExchangeFactory();
        result.setInterfaceName(interfaceName);
        return result;
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName serviceName) {
        MessageExchangeFactoryImpl result = this.createMessageExchangeFactory();
        result.setServiceName(serviceName);
        return result;
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint endpoint) {
        MessageExchangeFactoryImpl result = this.createMessageExchangeFactory();
        result.setEndpoint(endpoint);
        return result;
    }

    protected MessageExchangeFactoryImpl createMessageExchangeFactory() {
        MessageExchangeFactoryImpl messageExchangeFactory = new MessageExchangeFactoryImpl(this.idGenerator, this.closed);
        messageExchangeFactory.setContext(this.context);
        return messageExchangeFactory;
    }

    public MessageExchange accept() throws MessagingException {
        return this.accept(Long.MAX_VALUE);
    }

    public MessageExchange accept(long timeoutMS) throws MessagingException {
        try {
            this.checkNotClosed();
            MessageExchangeImpl me = this.queue.poll(timeoutMS, TimeUnit.MILLISECONDS);
            if (me != null) {
                if (me.getPacket().isAborted()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Aborted " + me.getExchangeId() + " in " + this));
                    }
                    me = null;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Accepting " + me.getExchangeId() + " in " + this));
                    }
                    if (me.getTxLock() != null && me.getStatus() != ExchangeStatus.ACTIVE) {
                        this.notifyExchange(me.getMirror(), me.getTxLock(), "acceptFinishedExchangeWithTxLock");
                        me.handleAccept();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Accepted: " + me));
                        }
                    } else if (me.isTransacted() && me.getStatus() != ExchangeStatus.ACTIVE) {
                        me.handleAccept();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Accepted: " + me));
                        }
                    } else {
                        this.resumeTx(me);
                        me.handleAccept();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Accepted: " + me));
                        }
                    }
                }
            }
            if (me != null) {
                ExchangeListener[] l = (ExchangeListener[])this.container.getListeners(ExchangeListener.class);
                ExchangeEvent event = new ExchangeEvent(me, 1);
                for (int i = 0; i < l.length; ++i) {
                    try {
                        l[i].exchangeAccepted(event);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error calling listener: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            return me;
        }
        catch (InterruptedException e) {
            throw new MessagingException("accept failed", (Throwable)e);
        }
    }

    protected void autoSetPersistent(MessageExchangeImpl me) {
        Boolean persistent = me.getPersistent();
        if (persistent == null) {
            persistent = this.context.getActivationSpec().getPersistent() != null ? this.context.getActivationSpec().getPersistent() : Boolean.valueOf(this.context.getContainer().isPersistent());
            me.setPersistent(persistent);
        }
    }

    protected void throttle() {
        if (this.component.isExchangeThrottling()) {
            if (this.component.getThrottlingInterval() > this.intervalCount) {
                this.intervalCount = 0;
                try {
                    Thread.sleep(this.component.getThrottlingTimeout());
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"throttling failed", (Throwable)e);
                }
            }
            ++this.intervalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(MessageExchangeImpl me, boolean sync) throws MessagingException {
        MessageExchangeImpl mirror = me.getMirror();
        boolean finished = me.getStatus() != ExchangeStatus.ACTIVE;
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Sent: " + me));
            }
            if (me.getPacket().isAborted()) {
                throw new ExchangeTimeoutException(me);
            }
            this.autoEnlistInTx(me);
            this.autoSetPersistent(me);
            this.throttle();
            if (me.getRole() == MessageExchange.Role.CONSUMER) {
                me.setSourceId(this.component.getComponentNameSpace());
            }
            Object l = (ExchangeListener[])this.container.getListeners(ExchangeListener.class);
            ExchangeEvent event = new ExchangeEvent(me, 0);
            for (int i = 0; i < ((ExchangeListener[])l).length; ++i) {
                try {
                    l[i].exchangeSent(event);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error calling listener: " + e.getMessage()), (Throwable)e);
                }
            }
            me.handleSend(sync);
            mirror.setTxState(0);
            if (finished && me.getTxLock() == null && me.getTxState() == 2 && !me.isPushDelivery() && me.getRole() == MessageExchange.Role.CONSUMER) {
                me.setTransactionContext(null);
            }
            this.container.sendExchange(mirror);
        }
        catch (MessagingException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Exception processing: " + me.getExchangeId() + " in " + this));
            }
            throw e;
        }
        finally {
            if (me.getTxLock() != null) {
                if (mirror.getTxState() == 1) {
                    this.suspendTx(mirror);
                }
                Object object = me.getTxLock();
                synchronized (object) {
                    this.notifyExchange(me, me.getTxLock(), "doSendWithTxLock");
                }
            }
        }
    }

    public void send(MessageExchange messageExchange) throws MessagingException {
        this.checkNotClosed();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Send " + messageExchange.getExchangeId() + " in " + this));
        }
        messageExchange.setProperty("javax.jbi.messaging.sendSync", null);
        MessageExchangeImpl me = (MessageExchangeImpl)messageExchange;
        this.doSend(me, false);
    }

    public boolean sendSync(MessageExchange messageExchange) throws MessagingException {
        return this.sendSync(messageExchange, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendSync(MessageExchange messageExchange, long timeout) throws MessagingException {
        this.checkNotClosed();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SendSync " + messageExchange.getExchangeId() + " in " + this));
        }
        boolean result = false;
        messageExchange.setProperty("javax.jbi.messaging.sendSync", (Object)Boolean.TRUE);
        MessageExchangeImpl me = (MessageExchangeImpl)messageExchange;
        String exchangeKey = me.getKey();
        try {
            this.exchangesById.put(exchangeKey, me);
            MessageExchangeImpl messageExchangeImpl = me;
            synchronized (messageExchangeImpl) {
                this.doSend(me, true);
                if (me.getSyncState() != 2) {
                    this.waitForExchange(me, me, timeout, "sendSync");
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Exchange " + messageExchange.getExchangeId() + " has already been answered (no need to wait)"));
                }
            }
            if (me.getSyncState() == 2) {
                me.handleAccept();
                this.resumeTx(me);
                result = true;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Exchange " + messageExchange.getExchangeId() + " has been aborted"));
                }
                me.getPacket().setAborted(true);
                result = false;
            }
        }
        catch (InterruptedException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.exchangesById.remove(exchangeKey);
        }
        return result;
    }

    public JBIContainer getContainer() {
        return this.container;
    }

    public void setContainer(JBIContainer container) {
        this.container = container;
    }

    public ComponentMBeanImpl getComponent() {
        return this.component;
    }

    public ComponentContextImpl getContext() {
        return this.context;
    }

    public void setContext(ComponentContextImpl context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processInBound(MessageExchangeImpl me) throws MessagingException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing inbound exchange: " + me));
        }
        this.checkNotClosed();
        MessageExchangeImpl original = this.exchangesById.get(me.getKey());
        if (original != null && me != original) {
            original.copyFrom(me);
            me = original;
        }
        if (me.getSyncState() == 1) {
            this.suspendTx(original);
            me.setSyncState(2);
            this.notifyExchange(original, original, "processInboundSynchronousExchange");
            return;
        }
        MessageExchangeListener listener = this.getExchangeListener();
        if (listener != null) {
            me.handleAccept();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Received: " + me));
            }
            ExchangeListener[] l = (ExchangeListener[])this.container.getListeners(ExchangeListener.class);
            ExchangeEvent event = new ExchangeEvent(me, 1);
            for (int i = 0; i < l.length; ++i) {
                try {
                    l[i].exchangeAccepted(event);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error calling listener: " + e.getMessage()), (Throwable)e);
                }
            }
            me.setPushDeliver(true);
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.component.getComponent().getClass().getClassLoader());
                listener.onMessageExchange(me);
                return;
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        if (me.isTransacted() && me.getStatus() == ExchangeStatus.ACTIVE) {
            Object lock;
            if (me.getTxState() == 2) {
                try {
                    this.suspendTx(me);
                    this.queue.put(me);
                    return;
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)("Exchange " + me.getExchangeId() + " aborted due to thread interruption"), (Throwable)e);
                    me.getPacket().setAborted(true);
                }
                return;
            }
            Object object = lock = new Object();
            synchronized (object) {
                try {
                    me.setTxLock(lock);
                    this.suspendTx(me);
                    this.queue.put(me);
                    this.waitForExchange(me, lock, 0L, "processInboundTransactionalExchange");
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)("Exchange " + me.getExchangeId() + " aborted due to thread interruption"), (Throwable)e);
                    me.getPacket().setAborted(true);
                }
                finally {
                    me.setTxLock(null);
                    this.resumeTx(me);
                }
                return;
            }
        }
        try {
            this.queue.put(me);
            return;
        }
        catch (InterruptedException e) {
            LOG.debug((Object)("Exchange " + me.getExchangeId() + " aborted due to thread interruption"), (Throwable)e);
            me.getPacket().setAborted(true);
        }
    }

    protected MessageExchangeListener getExchangeListener() {
        Component comp = this.component.getComponent();
        if (comp instanceof MessageExchangeListener) {
            return (MessageExchangeListener)comp;
        }
        ComponentLifeCycle lifecycle = this.component.getLifeCycle();
        if (lifecycle instanceof MessageExchangeListener) {
            return (MessageExchangeListener)lifecycle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForExchange(MessageExchangeImpl me, Object lock, long timeout, String from) throws InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Waiting for exchange " + me.getExchangeId() + " (" + Integer.toHexString(me.hashCode()) + ") to be answered in " + this + " from " + from));
        }
        Thread th = Thread.currentThread();
        try {
            this.waiters.put(th, Boolean.TRUE);
            lock.wait(timeout);
        }
        finally {
            this.waiters.remove(th);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Notified: " + me.getExchangeId() + "(" + Integer.toHexString(me.hashCode()) + ") in " + this + " from " + from));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyExchange(MessageExchangeImpl me, Object lock, String from) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Notifying exchange " + me.getExchangeId() + "(" + Integer.toHexString(me.hashCode()) + ") in " + this + " from " + from));
        }
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    public MessageExchangeFactory getInboundFactory() {
        if (this.inboundFactory == null) {
            this.inboundFactory = this.createExchangeFactory();
        }
        return this.inboundFactory;
    }

    protected void suspendTx(MessageExchangeImpl me) {
        if (this.transactionManager != null) {
            try {
                Transaction oldTx = me.getTransactionContext();
                if (oldTx != null) {
                    Transaction tx;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Suspending transaction for " + me.getExchangeId() + " in " + this));
                    }
                    if ((tx = this.transactionManager.suspend()) != oldTx) {
                        throw new IllegalStateException("the transaction context set in the messageExchange is not bound to the current thread");
                    }
                }
            }
            catch (Exception e) {
                LOG.info((Object)("Exchange " + me.getExchangeId() + " aborted due to transaction exception"), (Throwable)e);
                me.getPacket().setAborted(true);
            }
        }
    }

    protected void resumeTx(MessageExchangeImpl me) throws MessagingException {
        if (this.transactionManager != null) {
            try {
                Transaction oldTx = me.getTransactionContext();
                if (oldTx != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Resuming transaction for " + me.getExchangeId() + " in " + this));
                    }
                    this.transactionManager.resume(oldTx);
                }
            }
            catch (Exception e) {
                throw new MessagingException((Throwable)e);
            }
        }
    }

    protected void autoEnlistInTx(MessageExchangeImpl me) throws MessagingException {
        if (this.transactionManager != null && this.container.isAutoEnlistInTransaction()) {
            try {
                Transaction tx = this.transactionManager.getTransaction();
                if (tx != null) {
                    Transaction oldTx = me.getTransactionContext();
                    if (oldTx == null) {
                        me.setTransactionContext(tx);
                    } else if (oldTx != tx) {
                        throw new IllegalStateException("the transaction context set in the messageExchange is not bound to the current thread");
                    }
                }
            }
            catch (Exception e) {
                throw new MessagingException((Throwable)e);
            }
        }
    }

    public String toString() {
        return "DeliveryChannel{" + this.component.getName() + "}";
    }
}

