/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.io.Serializable;
import javax.jbi.JBIException;
import javax.management.JMException;
import javax.management.MBeanOperationInfo;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.client.DefaultServiceMixClient;
import org.apache.servicemix.client.ServiceMixClient;
import org.apache.servicemix.jbi.framework.ClientFactoryMBean;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.OperationInfoHelper;

public class ClientFactory
extends BaseSystemService
implements ClientFactoryMBean,
Serializable {
    private static final Log LOG = LogFactory.getLog(ClientFactory.class);
    private String jndiName = "java:comp/env/jbi/ClientFactory";
    private boolean isFactoryJNDIregistered;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public ServiceMixClient createClient() throws JBIException {
        return new DefaultServiceMixClient(this.getContainer());
    }

    protected Class getServiceMBean() {
        return ClientFactoryMBean.class;
    }

    public String getDescription() {
        return "Client Factory Service";
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "createClient", 0, "create a new client");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }

    public void start() throws JBIException {
        try {
            this.getContainer().getNamingContext().bind(this.jndiName, (Object)this);
            this.isFactoryJNDIregistered = true;
        }
        catch (NamingException e) {
            LOG.warn((Object)("Cound not start ClientFactory: " + e));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Could not start ClientFactory", (Throwable)e);
            }
            this.isFactoryJNDIregistered = false;
        }
        super.start();
    }

    public void stop() throws JBIException {
        block3: {
            super.stop();
            try {
                if (this.isFactoryJNDIregistered) {
                    this.getContainer().getNamingContext().unbind(this.jndiName);
                }
            }
            catch (NamingException e) {
                LOG.warn((Object)("Cound not stop ClientFactory: " + e));
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Could not stop ClientFactory", (Throwable)e);
            }
        }
    }
}

