/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.AdminCommandsService;
import org.springframework.beans.factory.InitializingBean;

public abstract class DeploySupport
implements InitializingBean {
    private static final transient Log LOG = LogFactory.getLog(DeploySupport.class);
    private JBIContainer jbiContainer;
    private AdminCommandsService commandsService;
    private boolean deferException;
    private String homeDir;
    private String repositoryDir;
    private String groupId;
    private String artifactId;
    private String version;
    private String type = "-installer.zip";
    private String file;

    public void afterPropertiesSet() throws Exception {
    }

    public void deploy(JBIContainer container) throws Exception {
        this.setJbiContainer(container);
        if (container == null) {
            throw new IllegalArgumentException("No JBI container configured!");
        }
        if (this.getCommandsService() == null) {
            this.setCommandsService(this.getJbiContainer().getAdminCommandsService());
        }
        this.doDeploy();
    }

    public JBIContainer getJbiContainer() {
        return this.jbiContainer;
    }

    public void setJbiContainer(JBIContainer jbiContainer) {
        this.jbiContainer = jbiContainer;
    }

    public AdminCommandsService getCommandsService() {
        return this.commandsService;
    }

    public void setCommandsService(AdminCommandsService commandsService) {
        this.commandsService = commandsService;
    }

    public boolean isDeferException() {
        return this.deferException;
    }

    public void setDeferException(boolean deferException) {
        this.deferException = deferException;
    }

    public String getArtifactId() {
        if (this.artifactId == null) {
            throw new IllegalArgumentException("You must specify either a file or a groupId and an artifactId property");
        }
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getGroupId() {
        if (this.groupId == null) {
            throw new IllegalArgumentException("You must specify either a file or a groupId and an artifactId property");
        }
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getHomeDir() {
        if (this.homeDir == null) {
            this.homeDir = System.getProperty("user.home", "~");
        }
        return this.homeDir;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    public String getRepositoryDir() {
        if (this.repositoryDir == null) {
            this.repositoryDir = this.getHomeDir() + "/.m2/repository";
        }
        return this.repositoryDir;
    }

    public void setRepositoryDir(String repositoryDir) {
        this.repositoryDir = repositoryDir;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = this.createVersion();
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getFile() {
        if (this.file == null) {
            this.file = this.createFile();
        }
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected abstract void doDeploy() throws Exception;

    protected String createFile() {
        String group = this.getGroupId();
        String artifact = this.getArtifactId();
        String v = this.getVersion();
        if (v == null) {
            throw new IllegalArgumentException("You must specify a version property as it could not be deduced for " + this.getGroupId() + ":" + this.getArtifactId());
        }
        group = group.replace('.', '/');
        return this.getFilePrefix() + this.getRepositoryDir() + "/" + group + "/" + artifact + "/" + v + "/" + artifact + "-" + v + this.type;
    }

    protected String createVersion() {
        String group = this.getGroupId();
        String artifact = this.getArtifactId();
        String key = group + "/" + artifact + "/version";
        try {
            Enumeration<URL> iter = Thread.currentThread().getContextClassLoader().getResources("META-INF/maven/dependencies.properties");
            while (iter.hasMoreElements()) {
                URL url = iter.nextElement();
                LOG.debug((Object)("looking into properties file: " + url + " with key: " + key));
                Properties properties = new Properties();
                InputStream in = url.openStream();
                properties.load(in);
                in.close();
                String answer = properties.getProperty(key);
                if (answer == null) continue;
                answer = answer.trim();
                LOG.debug((Object)("Found version: " + answer));
                return answer;
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Failed: " + e), (Throwable)e);
        }
        return null;
    }

    protected String getFilePrefix() {
        return this.isFileUrlFormat() ? "file://" : "";
    }

    protected boolean isFileUrlFormat() {
        return true;
    }
}

