/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.container;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.DeploySupport;
import org.apache.servicemix.jbi.container.InstallSharedLibrary;

public class DeployServiceAssembly
extends DeploySupport {
    private static final transient Log LOG = LogFactory.getLog(InstallSharedLibrary.class);
    private String serviceAssemblyName;

    public DeployServiceAssembly() {
        this.setType(".zip");
    }

    public String getServiceAssemblyName() {
        if (this.serviceAssemblyName == null) {
            return this.getArtifactId();
        }
        return this.serviceAssemblyName;
    }

    public void setServiceAssemblyName(String serviceAssemblyName) {
        this.serviceAssemblyName = serviceAssemblyName;
    }

    protected void doDeploy() throws Exception {
        String name = this.getServiceAssemblyName();
        if (name == null) {
            throw new IllegalArgumentException("You must specify a serviceAssemblyName or an artifactId property");
        }
        String file = this.getFile();
        LOG.info((Object)("Deploying shared library: " + file));
        this.getCommandsService().deployServiceAssembly(file, this.isDeferException());
        this.getCommandsService().startServiceAssembly(name);
    }
}

