/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.servicemix.components.util.ColumnExtractor;

public class VariableFixedLengthColumnExtractor
implements ColumnExtractor {
    private int discriminatorIndex;
    private int lastFixedContentIndex;
    private int maximumColumnCount;
    private int[] fixedColumnLengths;
    private Map variableColumnLengths;

    public String[] extractColumns(String lineText) {
        String[] result = new String[this.maximumColumnCount];
        int curIndex = 0;
        for (int i = 0; i <= this.lastFixedContentIndex; ++i) {
            try {
                result[i] = lineText.substring(curIndex, curIndex + this.fixedColumnLengths[i]);
                curIndex += this.fixedColumnLengths[i];
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                return result;
            }
        }
        if (result.length > this.discriminatorIndex) {
            String discriminatorValue = result[this.discriminatorIndex];
            if (StringUtils.isNotBlank((String)discriminatorValue) && this.variableColumnLengths != null && this.variableColumnLengths.containsKey(discriminatorValue)) {
                int[] variableLengths = (int[])this.variableColumnLengths.get(discriminatorValue);
                int variableIndex = 0;
                int i = this.lastFixedContentIndex + 1;
                while (i < this.maximumColumnCount) {
                    block9: {
                        try {
                            if (variableLengths[variableIndex] == -1) break block9;
                            result[i] = lineText.substring(curIndex, curIndex + variableLengths[variableIndex]);
                            curIndex += variableLengths[variableIndex];
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            break;
                        }
                    }
                    ++i;
                    ++variableIndex;
                }
            }
        } else {
            throw new IllegalStateException("Discriminator Column could not be read");
        }
        return result;
    }

    public final void setFixedColumnLengths(int[] fixedColumnLengths) {
        this.fixedColumnLengths = fixedColumnLengths;
    }

    public final void setStringFixedColumnLengths(String[] lengths) {
        this.fixedColumnLengths = new int[lengths.length];
        for (int i = 0; i < lengths.length; ++i) {
            this.fixedColumnLengths[i] = Integer.parseInt(lengths[i]);
        }
    }

    public final void setMaximumColumnCount(int maximumColumnCount) {
        this.maximumColumnCount = maximumColumnCount;
    }

    public final void setDiscriminatorIndex(int discriminatorIndex) {
        this.discriminatorIndex = discriminatorIndex;
    }

    public final void setLastFixedContentIndex(int lastFixedContentIndex) {
        this.lastFixedContentIndex = lastFixedContentIndex;
    }

    public final void setVariableColumnLengths(Map variableColumnLengths) {
        this.variableColumnLengths = variableColumnLengths;
    }

    public final void setStringEncodedVariableColumnLengths(String columnLengths) {
        this.variableColumnLengths = null;
        String[] entries = StringUtils.split((String)columnLengths, (String)";");
        if (entries != null && entries.length > 0) {
            this.variableColumnLengths = new LinkedHashMap();
            for (int i = 0; i < entries.length; ++i) {
                String[] colLengths = StringUtils.splitPreserveAllTokens((String)entries[i], (String)",");
                if (colLengths == null || colLengths.length <= 1) continue;
                int[] lengths = new int[colLengths.length - 1];
                for (int j = 1; j < colLengths.length; ++j) {
                    lengths[j - 1] = Integer.parseInt(colLengths[j]);
                }
                this.variableColumnLengths.put(colLengths[0], lengths);
            }
        }
    }
}

