/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.components.util.CopyTransformer;

public abstract class TransformComponentSupport
extends ComponentSupport
implements MessageExchangeListener {
    private boolean copyProperties = true;
    private boolean copyAttachments = true;

    protected TransformComponentSupport() {
    }

    protected TransformComponentSupport(QName service, String endpoint) {
        super(service, endpoint);
    }

    public void onMessageExchange(MessageExchange exchange) {
        block17: {
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                return;
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                return;
            }
            try {
                NormalizedMessage out;
                InOnly outExchange = null;
                NormalizedMessage in = this.getInMessage(exchange);
                if (this.isInAndOut(exchange)) {
                    out = exchange.createMessage();
                } else {
                    outExchange = this.getExchangeFactory().createInOnlyExchange();
                    outExchange.setProperty("org.apache.servicemix.senderEndpoint", (Object)(this.getService() + ":" + this.getEndpoint()));
                    String processCorrelationId = (String)exchange.getProperty("org.apache.servicemix.correlationId");
                    if (processCorrelationId != null) {
                        outExchange.setProperty("org.apache.servicemix.correlationId", (Object)processCorrelationId);
                    }
                    out = outExchange.createMessage();
                }
                boolean txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
                this.copyPropertiesAndAttachments(exchange, in, out);
                if (this.transform(exchange, in, out)) {
                    if (this.isInAndOut(exchange)) {
                        exchange.setMessage(out, "out");
                        if (txSync) {
                            this.getDeliveryChannel().sendSync(exchange);
                        } else {
                            this.getDeliveryChannel().send(exchange);
                        }
                    } else {
                        outExchange.setMessage(out, "in");
                        if (txSync) {
                            this.getDeliveryChannel().sendSync((MessageExchange)outExchange);
                        } else {
                            this.getDeliveryChannel().send((MessageExchange)outExchange);
                        }
                        exchange.setStatus(ExchangeStatus.DONE);
                        this.getDeliveryChannel().send(exchange);
                    }
                } else {
                    exchange.setStatus(ExchangeStatus.DONE);
                    this.getDeliveryChannel().send(exchange);
                }
            }
            catch (Exception e) {
                try {
                    this.fail(exchange, e);
                }
                catch (Exception e2) {
                    this.logger.warn((Object)("Unable to handle error: " + e2), (Throwable)e2);
                    if (!this.logger.isDebugEnabled()) break block17;
                    this.logger.debug((Object)("Original error: " + e), (Throwable)e);
                }
            }
        }
    }

    protected abstract boolean transform(MessageExchange var1, NormalizedMessage var2, NormalizedMessage var3) throws Exception;

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
        if (this.getMessageTransformer() instanceof CopyTransformer) {
            ((CopyTransformer)this.getMessageTransformer()).setCopyProperties(copyProperties);
        }
    }

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
        if (this.getMessageTransformer() instanceof CopyTransformer) {
            ((CopyTransformer)this.getMessageTransformer()).setCopyAttachments(copyAttachments);
        }
    }

    protected void copyPropertiesAndAttachments(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        if (this.isCopyProperties()) {
            CopyTransformer.copyProperties(in, out);
        }
        if (this.isCopyAttachments()) {
            CopyTransformer.copyAttachments(in, out);
        }
    }
}

