/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import javax.jbi.JBIException;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.MissingPropertyException;
import org.apache.servicemix.jbi.NoServiceAvailableException;

public class PipelineComponent
extends ComponentSupport
implements MessageExchangeListener {
    private ServiceEndpoint requestResponseEndpoint;
    private ServiceEndpoint outputEndpoint;
    private QName requestResponseServiceName;
    private QName outputEndpointServiceName;

    public PipelineComponent() {
    }

    public PipelineComponent(QName service, String endpoint) {
        super(service, endpoint);
    }

    public void start() throws JBIException {
        super.start();
        if (this.requestResponseEndpoint == null) {
            if (this.requestResponseServiceName == null) {
                throw new MissingPropertyException("requestResponseServiceName");
            }
            this.requestResponseEndpoint = this.chooseEndpoint(this.requestResponseServiceName);
        }
        if (this.outputEndpoint == null) {
            if (this.outputEndpointServiceName == null) {
                throw new MissingPropertyException("outputEndpointServiceName");
            }
            this.outputEndpoint = this.chooseEndpoint(this.outputEndpointServiceName);
        }
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        DeliveryChannel deliveryChannel = this.getDeliveryChannel();
        MessageExchangeFactory rpcFactory = deliveryChannel.createExchangeFactory(this.requestResponseEndpoint);
        InOut rpc = rpcFactory.createInOutExchange();
        rpc.setInMessage(exchange.getMessage("in"));
        boolean answer = deliveryChannel.sendSync((MessageExchange)rpc);
        MessageExchangeFactory outputFactory = deliveryChannel.createExchangeFactory(this.outputEndpoint);
        InOnly inOnly = outputFactory.createInOnlyExchange();
        if (answer) {
            inOnly.setInMessage(rpc.getOutMessage());
            deliveryChannel.send((MessageExchange)inOnly);
            this.done(exchange);
        } else if (!(exchange instanceof InOnly)) {
            inOnly.setError(rpc.getError());
            Fault fault = rpc.getFault();
            this.fail(exchange, fault);
        } else {
            this.done(exchange);
        }
        this.done((MessageExchange)rpc);
    }

    public ServiceEndpoint getRequestResponseEndpoint() {
        return this.requestResponseEndpoint;
    }

    public void setRequestResponseEndpoint(ServiceEndpoint requestResponseEndpoint) {
        this.requestResponseEndpoint = requestResponseEndpoint;
    }

    public ServiceEndpoint getOutputEndpoint() {
        return this.outputEndpoint;
    }

    public void setOutputEndpoint(ServiceEndpoint outputEndpoint) {
        this.outputEndpoint = outputEndpoint;
    }

    public QName getRequestResponseServiceName() {
        return this.requestResponseServiceName;
    }

    public void setRequestResponseServiceName(QName requestResponseServiceName) {
        this.requestResponseServiceName = requestResponseServiceName;
    }

    public QName getOutputEndpointServiceName() {
        return this.outputEndpointServiceName;
    }

    public void setOutputEndpointServiceName(QName outputEndpointServiceName) {
        this.outputEndpointServiceName = outputEndpointServiceName;
    }

    protected ServiceEndpoint chooseEndpoint(QName serviceName) throws JBIException {
        ServiceEndpoint[] endpoints = this.getContext().getEndpointsForService(serviceName);
        if (endpoints == null || endpoints.length == 0) {
            throw new NoServiceAvailableException(serviceName);
        }
        return endpoints[0];
    }
}

