/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.components.util.ServiceUnitManagerSupport;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class ComponentAdaptor
implements Component {
    private ComponentLifeCycle lifeCycle;
    private QName service;
    private String endpoint;
    private ComponentContext context;
    private ServiceUnitManager serviceManager;

    public ComponentAdaptor(ComponentLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public ComponentAdaptor(ComponentLifeCycle lifeCycle, QName service, String endpoint) {
        this.lifeCycle = lifeCycle;
        this.service = service;
        this.endpoint = endpoint;
    }

    public void init(ComponentContext ctx) throws JBIException {
        this.context = ctx;
        if (this.service != null && this.endpoint != null) {
            ctx.activateEndpoint(this.service, this.endpoint);
        }
    }

    public ComponentLifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public ServiceUnitManager getServiceUnitManager() {
        this.initializeServiceUnitManager();
        return this.serviceManager;
    }

    public void setServiceManager(ServiceUnitManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.lifeCycle;
    }

    protected synchronized void initializeServiceUnitManager() {
        if (this.serviceManager == null) {
            this.serviceManager = this.createServiceUnitManager();
        }
    }

    protected ServiceUnitManager createServiceUnitManager() {
        return new ServiceUnitManagerSupport();
    }

    public Document getServiceDescription(ServiceEndpoint ep) {
        return null;
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint ep, MessageExchange exchange) {
        return true;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint ep, MessageExchange exchange) {
        return true;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        return null;
    }
}

