/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.log.UnrecoverableLog;
import org.apache.geronimo.transaction.manager.MonitorableTransactionManager;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.Recovery;
import org.apache.geronimo.transaction.manager.RecoveryImpl;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.TransactionManagerMonitor;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.apache.geronimo.transaction.manager.XidImporter;

public class TransactionManagerImpl
implements TransactionManager,
UserTransaction,
TransactionSynchronizationRegistry,
XidImporter,
MonitorableTransactionManager,
RecoverableTransactionManager {
    private static final Log log = LogFactory.getLog(TransactionManagerImpl.class);
    protected static final int DEFAULT_TIMEOUT = 600;
    protected static final byte[] DEFAULT_TM_ID = new byte[]{71, 84, 77, 73, 68};
    final TransactionLog transactionLog;
    final XidFactory xidFactory;
    private final int defaultTransactionTimeoutMilliseconds;
    private final ThreadLocal transactionTimeoutMilliseconds = new ThreadLocal();
    private final ThreadLocal threadTx = new ThreadLocal();
    private final ConcurrentHashMap associatedTransactions = new ConcurrentHashMap();
    private static final Log recoveryLog = LogFactory.getLog((String)"RecoveryController");
    final Recovery recovery;
    private final CopyOnWriteArrayList transactionAssociationListeners = new CopyOnWriteArrayList();
    private List recoveryErrors = new ArrayList();

    public TransactionManagerImpl() throws XAException {
        this(600, null, null);
    }

    public TransactionManagerImpl(int defaultTransactionTimeoutSeconds) throws XAException {
        this(defaultTransactionTimeoutSeconds, null, null);
    }

    public TransactionManagerImpl(int defaultTransactionTimeoutSeconds, TransactionLog transactionLog) throws XAException {
        this(defaultTransactionTimeoutSeconds, null, transactionLog);
    }

    public TransactionManagerImpl(int defaultTransactionTimeoutSeconds, XidFactory xidFactory, TransactionLog transactionLog) throws XAException {
        if (defaultTransactionTimeoutSeconds <= 0) {
            throw new IllegalArgumentException("defaultTransactionTimeoutSeconds must be positive: attempted value: " + defaultTransactionTimeoutSeconds);
        }
        this.defaultTransactionTimeoutMilliseconds = defaultTransactionTimeoutSeconds * 1000;
        this.transactionLog = transactionLog == null ? new UnrecoverableLog() : transactionLog;
        this.xidFactory = xidFactory != null ? xidFactory : new XidFactoryImpl(DEFAULT_TM_ID);
        this.recovery = new RecoveryImpl(this.transactionLog, this.xidFactory);
    }

    public Transaction getTransaction() {
        return (Transaction)this.threadTx.get();
    }

    private void associate(TransactionImpl tx) throws InvalidTransactionException {
        if (tx == null) {
            throw new NullPointerException("tx is null");
        }
        Thread existingAssociation = this.associatedTransactions.putIfAbsent(tx, Thread.currentThread());
        if (existingAssociation != null) {
            throw new InvalidTransactionException("Specified transaction is already associated with another thread");
        }
        this.threadTx.set(tx);
        this.fireThreadAssociated(tx);
    }

    private void unassociate() {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            this.associatedTransactions.remove(tx);
            this.threadTx.set(null);
            this.fireThreadUnassociated(tx);
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw new SystemException("transaction timeout must be positive or 0 to reset to default");
        }
        if (seconds == 0) {
            this.transactionTimeoutMilliseconds.set(null);
        } else {
            this.transactionTimeoutMilliseconds.set(new Long(seconds * 1000));
        }
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(this.getTransactionTimeoutMilliseconds(0L));
    }

    public Transaction begin(long transactionTimeoutMilliseconds) throws NotSupportedException, SystemException {
        if (this.getStatus() != 6) {
            throw new NotSupportedException("Nested Transactions are not supported");
        }
        TransactionImpl tx = new TransactionImpl(this.xidFactory, this.transactionLog, this.getTransactionTimeoutMilliseconds(transactionTimeoutMilliseconds));
        try {
            this.associate(tx);
        }
        catch (InvalidTransactionException e) {
            throw (SystemException)new SystemException("Internal error: associate threw an InvalidTransactionException for a newly created transaction").initCause((Throwable)e);
        }
        this.transactionTimeoutMilliseconds.set(null);
        return tx;
    }

    public Transaction suspend() throws SystemException {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            this.unassociate();
        }
        return tx;
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
        if (this.getTransaction() != null) {
            throw new IllegalStateException("Thread already associated with another transaction");
        }
        if (!(tx instanceof TransactionImpl)) {
            throw new InvalidTransactionException("Cannot resume foreign transaction: " + tx);
        }
        this.associate((TransactionImpl)tx);
    }

    public Object getResource(Object key) {
        TransactionImpl tx = this.getActiveTransactionImpl();
        return tx.getResource(key);
    }

    private TransactionImpl getActiveTransactionImpl() {
        TransactionImpl tx = (TransactionImpl)this.threadTx.get();
        if (tx == null) {
            throw new IllegalStateException("No tx on thread");
        }
        if (tx.getStatus() != 0 && tx.getStatus() != 1) {
            throw new IllegalStateException("Transaction " + tx + " is not active");
        }
        return tx;
    }

    public boolean getRollbackOnly() {
        TransactionImpl tx = this.getActiveTransactionImpl();
        return tx.getRollbackOnly();
    }

    public Object getTransactionKey() {
        TransactionImpl tx = this.getActiveTransactionImpl();
        return tx.getTransactionKey();
    }

    public int getTransactionStatus() {
        TransactionImpl tx = (TransactionImpl)this.getTransaction();
        return tx == null ? 6 : tx.getTransactionStatus();
    }

    public void putResource(Object key, Object value) {
        TransactionImpl tx = this.getActiveTransactionImpl();
        tx.putResource(key, value);
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        TransactionImpl tx = this.getActiveTransactionImpl();
        tx.registerInterposedSynchronization(synchronization);
    }

    public void setRollbackOnly() throws IllegalStateException {
        TransactionImpl tx = (TransactionImpl)this.threadTx.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        tx.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        try {
            tx.commit();
        }
        finally {
            this.unassociate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        try {
            tx.rollback();
        }
        finally {
            this.unassociate();
        }
    }

    public Transaction importXid(Xid xid, long transactionTimeoutMilliseconds) throws XAException, SystemException {
        if (transactionTimeoutMilliseconds < 0L) {
            throw new SystemException("transaction timeout must be positive or 0 to reset to default");
        }
        TransactionImpl tx = new TransactionImpl(xid, this.xidFactory, this.transactionLog, this.getTransactionTimeoutMilliseconds(transactionTimeoutMilliseconds));
        return tx;
    }

    public void commit(Transaction tx, boolean onePhase) throws XAException {
        if (onePhase) {
            try {
                tx.commit();
            }
            catch (HeuristicMixedException e) {
                throw (XAException)new XAException().initCause(e);
            }
            catch (HeuristicRollbackException e) {
                throw (XAException)new XAException().initCause(e);
            }
            catch (RollbackException e) {
                throw (XAException)new XAException().initCause(e);
            }
            catch (SecurityException e) {
                throw (XAException)new XAException().initCause(e);
            }
            catch (SystemException e) {
                throw (XAException)new XAException().initCause(e);
            }
        }
        try {
            ((TransactionImpl)tx).preparedCommit();
        }
        catch (SystemException e) {
            throw (XAException)new XAException().initCause(e);
        }
    }

    public void forget(Transaction tx) throws XAException {
    }

    public int prepare(Transaction tx) throws XAException {
        try {
            return ((TransactionImpl)tx).prepare();
        }
        catch (SystemException e) {
            throw (XAException)new XAException().initCause(e);
        }
        catch (RollbackException e) {
            throw (XAException)new XAException().initCause(e);
        }
    }

    public void rollback(Transaction tx) throws XAException {
        try {
            tx.rollback();
        }
        catch (IllegalStateException e) {
            throw (XAException)new XAException().initCause(e);
        }
        catch (SystemException e) {
            throw (XAException)new XAException().initCause(e);
        }
    }

    long getTransactionTimeoutMilliseconds(long transactionTimeoutMilliseconds) {
        if (transactionTimeoutMilliseconds != 0L) {
            return transactionTimeoutMilliseconds;
        }
        Long timeout = (Long)this.transactionTimeoutMilliseconds.get();
        if (timeout != null) {
            return timeout;
        }
        return this.defaultTransactionTimeoutMilliseconds;
    }

    public void recoveryError(Exception e) {
        recoveryLog.error((Object)e);
        this.recoveryErrors.add(e);
    }

    public void recoverResourceManager(NamedXAResource xaResource) {
        try {
            this.recovery.recoverResourceManager(xaResource);
        }
        catch (XAException e) {
            this.recoveryError(e);
        }
    }

    public Map getExternalXids() {
        return new HashMap(this.recovery.getExternalXids());
    }

    public void addTransactionAssociationListener(TransactionManagerMonitor listener) {
        this.transactionAssociationListeners.addIfAbsent(listener);
    }

    public void removeTransactionAssociationListener(TransactionManagerMonitor listener) {
        this.transactionAssociationListeners.remove(listener);
    }

    protected void fireThreadAssociated(Transaction tx) {
        for (TransactionManagerMonitor listener : this.transactionAssociationListeners) {
            try {
                listener.threadAssociated(tx);
            }
            catch (Exception e) {
                log.warn((Object)"Error calling transaction association listener", (Throwable)e);
            }
        }
    }

    protected void fireThreadUnassociated(Transaction tx) {
        for (TransactionManagerMonitor listener : this.transactionAssociationListeners) {
            try {
                listener.threadUnassociated(tx);
            }
            catch (Exception e) {
                log.warn((Object)"Error calling transaction association listener", (Throwable)e);
            }
        }
    }
}

