/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.validation;

import java.io.IOException;
import javax.jbi.JBIException;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.servicemix.components.util.TransformComponentSupport;
import org.apache.servicemix.components.validation.CountingErrorHandlerFactory;
import org.apache.servicemix.components.validation.MessageAwareErrorHandler;
import org.apache.servicemix.components.validation.MessageAwareErrorHandlerFactory;
import org.apache.servicemix.jbi.FaultException;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class ValidateComponent
extends TransformComponentSupport {
    private Schema schema;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Source schemaSource;
    private Resource schemaResource;
    private MessageAwareErrorHandlerFactory errorHandlerFactory = new CountingErrorHandlerFactory();

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public Source getSchemaSource() {
        return this.schemaSource;
    }

    public void setSchemaSource(Source schemaSource) {
        this.schemaSource = schemaSource;
    }

    public Resource getSchemaResource() {
        return this.schemaResource;
    }

    public void setSchemaResource(Resource schemaResource) {
        this.schemaResource = schemaResource;
    }

    public MessageAwareErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setErrorHandlerFactory(MessageAwareErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    protected void init() throws JBIException {
        super.init();
        try {
            if (this.schema == null) {
                SchemaFactory factory = SchemaFactory.newInstance(this.schemaLanguage);
                if (this.schemaSource == null) {
                    if (this.schemaResource == null) {
                        throw new JBIException("You must specify a schema, schemaSource or schemaResource property");
                    }
                    this.schemaSource = this.schemaResource.getURL() == null ? new StreamSource(this.schemaResource.getInputStream()) : new StreamSource(this.schemaResource.getInputStream(), this.schemaResource.getURL().toExternalForm());
                }
                this.schema = factory.newSchema(this.schemaSource);
            }
        }
        catch (IOException e) {
            throw new JBIException("Failed to load schema: " + e, (Throwable)e);
        }
        catch (SAXException e) {
            throw new JBIException("Failed to load schema: " + e, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        Validator validator = this.schema.newValidator();
        MessageAwareErrorHandler errorHandler = this.errorHandlerFactory.createMessageAwareErrorHandler();
        validator.setErrorHandler(errorHandler);
        DOMResult result = new DOMResult();
        this.getMessageTransformer().transform(exchange, in, out);
        try {
            SourceTransformer sourceTransformer = new SourceTransformer();
            DOMSource src = sourceTransformer.toDOMSource(out.getContent());
            this.doValidation(validator, src, result);
            if (errorHandler.hasErrors()) {
                Fault fault = exchange.createFault();
                fault.setProperty("org.apache.servicemix.schema", (Object)this.schema);
                fault.setProperty("org.apache.servicemix.xml", (Object)src);
                if (errorHandler.capturesMessages()) {
                    if (errorHandler.supportsMessageFormat(DOMSource.class)) {
                        fault.setContent((Source)((DOMSource)errorHandler.getMessagesAs(DOMSource.class)));
                        throw new FaultException("Failed to validate against schema: " + this.schema, exchange, fault);
                    } else if (errorHandler.supportsMessageFormat(StringSource.class)) {
                        fault.setContent((Source)sourceTransformer.toDOMSource((Source)((StringSource)errorHandler.getMessagesAs(StringSource.class))));
                        throw new FaultException("Failed to validate against schema: " + this.schema, exchange, fault);
                    } else {
                        if (!errorHandler.supportsMessageFormat(String.class)) throw new MessagingException("MessageAwareErrorHandler implementation " + errorHandler.getClass().getName() + " does not support a compatible error message format.");
                        fault.setContent((Source)sourceTransformer.toDOMSource((Source)new StringSource((String)errorHandler.getMessagesAs(String.class))));
                    }
                    throw new FaultException("Failed to validate against schema: " + this.schema, exchange, fault);
                } else {
                    fault.setContent((Source)new DOMSource(result.getNode(), result.getSystemId()));
                }
                throw new FaultException("Failed to validate against schema: " + this.schema, exchange, fault);
            }
            out.setContent((Source)new DOMSource(result.getNode(), result.getSystemId()));
            return true;
        }
        catch (SAXException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    protected void doValidation(Validator validator, DOMSource src, DOMResult result) throws SAXException, IOException {
        validator.validate(src, result);
    }
}

