/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.splitter;

import java.io.IOException;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.servicemix.components.util.TransformComponentSupport;
import org.apache.servicemix.jbi.MissingPropertyException;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SplitterComponent
extends TransformComponentSupport {
    private String nodePath;
    private XPathExpression expression;
    private SourceTransformer st = new SourceTransformer();

    protected void init() throws JBIException {
        super.init();
        if (this.nodePath == null) {
            throw new MissingPropertyException("nodePath");
        }
    }

    protected boolean transform(MessageExchange me, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        NodeList nodes;
        try {
            Node doc = this.st.toDOMNode(in);
            if (this.expression == null) {
                XPath xpath = XPathFactory.newInstance().newXPath();
                this.expression = xpath.compile(this.nodePath);
            }
            nodes = (NodeList)this.expression.evaluate(doc, XPathConstants.NODESET);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw new MessagingException((Throwable)e);
        }
        int total = nodes.getLength();
        for (int i = 0; i < total; ++i) {
            out.setContent((Source)new DOMSource(nodes.item(i)));
            InOnly outExchange = this.getExchangeFactory().createInOnlyExchange();
            outExchange.setInMessage(out);
            this.getDeliveryChannel().sendSync((MessageExchange)outExchange);
            outExchange.setStatus(ExchangeStatus.DONE);
        }
        return false;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
        this.expression = null;
    }
}

