/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.saaj;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SaajMarshaler {
    private static final transient Log log = LogFactory.getLog(SaajMarshaler.class);
    protected SourceTransformer transformer = new SourceTransformer();
    private MessageFactory messageFactory;

    public void toNMS(NormalizedMessage normalizedMessage, SOAPMessage soapMessage) throws MessagingException, SOAPException {
        if (log.isDebugEnabled()) {
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                soapMessage.writeTo((OutputStream)buffer);
                log.debug((Object)new String(buffer.toByteArray()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.addNmsProperties(normalizedMessage, soapMessage);
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPBody soapBody = soapPart.getEnvelope().getBody();
        SOAPElement elem = null;
        Iterator it = soapBody.getChildElements();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof SOAPElement)) continue;
            elem = (SOAPElement)child;
            break;
        }
        if (elem == null) {
            throw new IllegalStateException("Could not find any element in soap body");
        }
        for (SOAPElement parent = elem.getParentElement(); parent != null; parent = parent.getParentElement()) {
            NamedNodeMap attributes = parent.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr att = (Attr)parent.getAttributes().item(i);
                    if (!att.getName().startsWith("xmlns:") || elem.getAttributeNodeNS(att.getNamespaceURI(), att.getLocalName()) != null) continue;
                    elem.addNamespaceDeclaration(att.getName().substring("xmlns".length() + 1), att.getValue());
                    elem.setAttributeNS(att.getNamespaceURI(), att.getName(), att.getValue());
                }
            }
            Iterator itNs = parent.getNamespacePrefixes();
            while (itNs.hasNext()) {
                String prefix = (String)itNs.next();
                String nsuri = parent.getNamespaceURI(prefix);
                if (elem.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix) != null) continue;
                elem.addNamespaceDeclaration(prefix, nsuri);
                elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsuri);
            }
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)this.transformer.toString((Node)elem));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        normalizedMessage.setContent((Source)new DOMSource((Node)elem));
        this.addNmsAttachments(normalizedMessage, soapMessage);
    }

    public SOAPMessage createSOAPMessage(NormalizedMessage normalizedMessage) throws SOAPException, IOException, TransformerException, MessagingException, ParserConfigurationException, SAXException {
        SOAPMessage soapMessage = this.getMessageFactory().createMessage();
        this.addSoapProperties(soapMessage, normalizedMessage);
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPBody body = envelope.getBody();
        Document document = this.transformer.toDOMDocument(normalizedMessage);
        body.addDocument(document);
        this.addSoapAttachments(soapMessage, normalizedMessage);
        return soapMessage;
    }

    public MessageFactory getMessageFactory() throws SOAPException {
        if (this.messageFactory == null) {
            this.messageFactory = this.createMessageFactory();
        }
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    protected void addNmsProperties(NormalizedMessage normalizedMessage, SOAPMessage soapMessage) {
        Iterator iter = soapMessage.getMimeHeaders().getAllHeaders();
        while (iter.hasNext()) {
            MimeHeader header = (MimeHeader)iter.next();
            normalizedMessage.setProperty(header.getName(), (Object)header.getValue());
        }
    }

    protected void addNmsAttachments(NormalizedMessage normalizedMessage, SOAPMessage soapMessage) throws MessagingException, SOAPException {
        Iterator iter = soapMessage.getAttachments();
        while (iter.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)iter.next();
            normalizedMessage.addAttachment(attachment.getContentId(), this.asDataHandler(attachment));
        }
    }

    protected void addSoapProperties(SOAPMessage soapMessage, NormalizedMessage normalizedMessage) throws SOAPException {
        for (String name : normalizedMessage.getPropertyNames()) {
            Object value;
            if (this.shouldIncludeHeader(normalizedMessage, name, value = normalizedMessage.getProperty(name))) {
                soapMessage.getMimeHeaders().addHeader(name, value.toString());
            }
            if (!this.shouldIncludeProperty(normalizedMessage, name, value)) continue;
            soapMessage.setProperty(name, value);
        }
    }

    protected void addSoapAttachments(SOAPMessage soapMessage, NormalizedMessage normalizedMessage) throws IOException {
        for (String name : normalizedMessage.getAttachmentNames()) {
            DataHandler attachment = normalizedMessage.getAttachment(name);
            AttachmentPart attachmentPart = soapMessage.createAttachmentPart(attachment.getContent(), attachment.getContentType());
            attachmentPart.setContentId(name);
            soapMessage.addAttachmentPart(attachmentPart);
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return true;
    }

    protected boolean shouldIncludeProperty(NormalizedMessage normalizedMessage, String name, Object value) {
        return true;
    }

    protected DataHandler asDataHandler(AttachmentPart attachment) throws SOAPException {
        return new DataHandler(attachment.getContent(), attachment.getContentType());
    }

    protected MessageFactory createMessageFactory() throws SOAPException {
        return MessageFactory.newInstance();
    }
}

