/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.jms;

import java.util.Date;
import java.util.Enumeration;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.servicemix.jbi.jaxp.SourceMarshaler;

public class JmsMarshaler {
    private SourceMarshaler sourceMarshaler;
    private boolean needJavaIdentifiers;

    public JmsMarshaler() {
        this(new SourceMarshaler());
    }

    public JmsMarshaler(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    public void toNMS(NormalizedMessage normalizedMessage, Message message) throws JMSException, MessagingException {
        this.addNmsProperties(normalizedMessage, message);
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            Source source = this.sourceMarshaler.asSource(textMessage.getText());
            normalizedMessage.setContent(source);
        }
    }

    public Message createMessage(NormalizedMessage normalizedMessage, Session session) throws JMSException, TransformerException {
        String xml = this.messageAsString(normalizedMessage);
        TextMessage message = session.createTextMessage(xml);
        this.addJmsProperties((Message)message, normalizedMessage);
        return message;
    }

    public SourceMarshaler getSourceMarshaller() {
        return this.sourceMarshaler;
    }

    public void setSourceMarshaller(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    protected String messageAsString(NormalizedMessage normalizedMessage) throws TransformerException {
        return this.sourceMarshaler.asString(normalizedMessage.getContent());
    }

    protected void addJmsProperties(Message message, NormalizedMessage normalizedMessage) throws JMSException {
        for (String name : normalizedMessage.getPropertyNames()) {
            Object value;
            if (!this.shouldIncludeHeader(normalizedMessage, name, value = normalizedMessage.getProperty(name))) continue;
            message.setObjectProperty(name, value);
        }
    }

    protected void addNmsProperties(NormalizedMessage message, Message jmsMessage) throws JMSException {
        Enumeration enumeration = jmsMessage.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Object value = jmsMessage.getObjectProperty(name);
            message.setProperty(name, value);
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return !(!(value instanceof String) && !(value instanceof Number) && !(value instanceof Date) || this.isNeedJavaIdentifiers() && !JmsMarshaler.isJavaIdentifier(name));
    }

    private static boolean isJavaIdentifier(String s) {
        int n = s.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isNeedJavaIdentifiers() {
        return this.needJavaIdentifiers;
    }

    public void setNeedJavaIdentifiers(boolean needJavaIdentifiers) {
        this.needJavaIdentifiers = needJavaIdentifiers;
    }
}

