/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.components.util.MarshalerSupport;
import org.apache.servicemix.jbi.jaxp.StringSource;

public class HttpMarshaler
extends MarshalerSupport {
    public static final String CGI_HEADERS = "cgi.headers";
    public static final String AUTH_TYPE = "AUTH_TYPE";
    public static final String CONTENT_LENGTH = "CONTENT_LENGTH";
    public static final String CONTENT_TYPE = "CONTENT_TYPE";
    public static final String DOCUMENT_ROOT = "DOCUMENT_ROOT";
    public static final String PATH_INFO = "PATH_INFO";
    public static final String PATH_TRANSLATED = "PATH_TRANSLATED";
    public static final String QUERY_STRING = "QUERY_STRING";
    public static final String REMOTE_ADDRESS = "REMOTE_ADDR";
    public static final String REMOTE_HOST = "REMOTE_HOST";
    public static final String REMOTE_USER = "REMOTE_USER";
    public static final String REQUEST_METHOD = "REQUEST_METHOD";
    public static final String REQUEST_URI = "REQUEST_URI";
    public static final String SCRIPT_NAME = "SCRIPT_NAME";
    public static final String SERVER_NAME = "SERVER_NAME";
    public static final String SERVER_PORT = "SERVER_PORT";
    public static final String SERVER_PROTOCOL = "SERVER_PROTOCOL";
    protected static final Source EMPTY_CONTENT = new StringSource("<payload/>");
    private String contentType = "text/xml";

    public void toNMS(MessageExchange exchange, NormalizedMessage inMessage, HttpServletRequest request) throws IOException, MessagingException {
        this.addNmsProperties(inMessage, request);
        String method = request.getMethod();
        if (method != null && method.equalsIgnoreCase("POST")) {
            inMessage.setContent((Source)new StreamSource((InputStream)request.getInputStream()));
        } else {
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = request.getParameter(name);
                inMessage.setProperty(name, (Object)value);
            }
            inMessage.setContent(EMPTY_CONTENT);
        }
    }

    public void toResponse(InOut exchange, NormalizedMessage message, HttpServletResponse response) throws IOException, TransformerException {
        if (message != null) {
            this.addHttpHeaders(response, message);
        }
        response.setContentType(this.contentType);
        this.getTransformer().toResult(message.getContent(), (Result)new StreamResult((OutputStream)response.getOutputStream()));
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected void addNmsProperties(NormalizedMessage message, HttpServletRequest request) {
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = request.getHeader(name);
            message.setProperty(name, (Object)value);
        }
        HashMap<String, CharSequence> cgi = new HashMap<String, CharSequence>();
        cgi.put(AUTH_TYPE, request.getAuthType());
        cgi.put(CONTENT_LENGTH, String.valueOf(request.getContentLength()));
        cgi.put(CONTENT_TYPE, request.getContentType());
        cgi.put(DOCUMENT_ROOT, request.getRealPath("/"));
        cgi.put(PATH_INFO, request.getPathInfo());
        cgi.put(PATH_TRANSLATED, request.getPathTranslated());
        cgi.put(QUERY_STRING, request.getQueryString());
        cgi.put(REMOTE_ADDRESS, request.getRemoteAddr());
        cgi.put(REMOTE_HOST, request.getRemoteHost());
        cgi.put(REMOTE_USER, request.getRemoteUser());
        cgi.put(REQUEST_METHOD, request.getMethod());
        cgi.put(REQUEST_URI, request.getRequestURL());
        cgi.put(SCRIPT_NAME, request.getServletPath());
        cgi.put(SERVER_NAME, request.getServerName());
        cgi.put(SERVER_PORT, String.valueOf(request.getServerPort()));
        cgi.put(SERVER_PROTOCOL, request.getProtocol());
        message.setProperty(CGI_HEADERS, cgi);
    }

    protected void addHttpHeaders(HttpServletResponse response, NormalizedMessage normalizedMessage) {
        for (String name : normalizedMessage.getPropertyNames()) {
            Object value;
            if (!this.shouldIncludeHeader(normalizedMessage, name, value = normalizedMessage.getProperty(name))) continue;
            response.setHeader(name, value.toString());
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return value instanceof String && !"Content-Length".equalsIgnoreCase(name) && !"Content-Type".equalsIgnoreCase(name);
    }
}

