/*
 * Class of the project 'Metamodeling in RDF/RDFS'
 * course 'Seminario di Ingegneria del Software'
 */
package seminarioIS;

import com.hp.hpl.jena.rdf.model.*;
import com.hp.hpl.jena.reasoner.rulesys.*;
import com.hp.hpl.jena.vocabulary.*;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.query.*;
import com.hp.hpl.jena.query.ResultSet;


/**
 * @author Alberto Cerullo
 */
public class LibraryEntity {
	
	public static final String uri = "http://somewhere#";
	public static final String uriFN = "http://www.w3.org/2001/vcard-rdf/3.0#";
	public static final String uriRDF =	"http://www.w3.org/1999/02/22-rdf-syntax-ns#";
	public static final String uriRDFS = RDFS.getURI();
	public static final String NL = System.getProperty("line.separator") ;
	
	public static Model createModel()
    {
		//Setting the model and creating the data.
		Model m = ModelFactory.createDefaultModel() ;
        m.setNsPrefix( "uri", uri );
        
        //All definitions of the Resources of meta level
        Resource entity = m.createResource(uri + "Entity") ;
        Resource quality = m.createResource(uri + "Quality") ;
        Resource event = m.createResource(uri + "Event") ;
        Resource object = m.createResource(uri + "Object") ;
        Resource abstractConcept = m.createResource(uri + "Abstract") ;
        quality.addProperty(RDFS.subClassOf ,entity );
        event.addProperty(RDFS.subClassOf ,entity );
        object.addProperty(RDFS.subClassOf ,entity );
        abstractConcept.addProperty(RDFS.subClassOf ,entity );
        entity.addProperty(RDF.type,RDFS.Class) ;
        quality.addProperty(RDF.type,RDFS.Class) ;
        event.addProperty(RDF.type,RDFS.Class) ;
        object.addProperty(RDF.type,RDFS.Class) ;
        abstractConcept.addProperty(RDF.type,RDFS.Class) ;
        
        //All definitions of the Resources of intensional level
        
        Resource libro = m.createResource(uri + "Libro") ;
        Resource autore = m.createResource(uri + "Autore") ;
        Resource letturaPubblica = m.createResource(uri + "LetturaPubblica") ;
        libro.addProperty(RDF.type, object)
			.addProperty(RDF.type,RDFS.Class) ;
        autore.addProperty(RDF.type, object)
			.addProperty(RDF.type,RDFS.Class) ;
        letturaPubblica.addProperty(RDF.type, event)
			.addProperty(RDF.type,RDFS.Class) ;
        Property autoreLibro = m.createProperty(uri + "autoreLibro");
        autoreLibro.addProperty(RDFS.domain,libro)
			.addProperty(RDFS.range,autore);
        Property titolo = m.createProperty(uri + "titolo");
        titolo.addProperty(RDFS.domain,libro)
			.addProperty(RDF.type,abstractConcept);
        Property letturaLibro = m.createProperty(uri + "letturaLibro");
        letturaLibro.addProperty(RDFS.domain,letturaPubblica) ;
        letturaLibro.addProperty(RDFS.range,libro);
        Property genere = m.createProperty(uri + "genere");
        genere.addProperty(RDFS.domain, libro)
		.addProperty(RDF.type,abstractConcept);
        
//      All definitions of the Resources of extensional level
        
        Resource autore1 = m.createResource(uri + "PDick") ;
        Resource libro1 = m.createResource(uri + "Ubik") ;        
        autore1.addProperty(VCARD.FN, "Philip Kindred Dick")
			.addProperty(RDF.type,autore);
		libro1.addProperty(autoreLibro,autore1)
			.addProperty(genere, uri + "Fantascienza")
			.addProperty(RDF.type,libro);
        libro1.addProperty(titolo,"Ubik");
        Resource libro2 = m.createResource(uri + "Paycheck") ;        
        libro2.addProperty(autoreLibro,autore1)
			.addProperty(genere,uri + "Fantascienza")
			.addProperty(RDF.type,libro);
        libro1.addProperty(titolo,"Ubik");
        Resource letturaUbik = m.createResource(uri + "lettura Ubik") ;
        letturaUbik.addProperty(DC.date,"2008-07-25");
        letturaUbik.addProperty(letturaLibro, libro1)
			.addProperty(RDF.type,letturaPubblica);
        
        return m ;
    }
	
	public static void queryAllEntity(Model model)	{
	    String prolog = "PREFIX uri: <"+uri+"> PREFIX uriFN: <"+uriFN+"> PREFIX uriRDF: <"+uriRDF+"> PREFIX uriRDFS: <"+uriRDFS+">" ;
	    String queryString = prolog + NL +
        "SELECT  DISTINCT ?x  ?type WHERE {?x uriRDF:"+
        	model.getProperty("type")+"  ?type. ?type uriRDFS:"+
			model.getProperty("subClassOf")+" uri:"+
        	model.getResource("Entity")+"." +
        			"}" ;
	    Query query = QueryFactory.create(queryString) ;
        // Print with line numbers
        query.serialize(new IndentedWriter(System.out,true)) ;
        System.out.println() ;
        QueryExecution qexec = QueryExecutionFactory.create(query, model) ;
        // Or QueryExecutionFactory.create(queryString, model) ;

        System.out.println("Tutte le entit: ") ;
        try {
            // Assumption: it's a SELECT query.
            ResultSet rs = qexec.execSelect() ;
            
            // The order of results is undefined. 
            for ( ; rs.hasNext() ; )
            {
                QuerySolution rb = rs.nextSolution() ;
                
                // Get title - variable names do not include the '?' (or '$')
                RDFNode x = rb.get("x") ;
                
                // Check the type of the result value
                if ( x.isLiteral() )
                {
                    Literal titleStr = (Literal)x  ;
                    System.out.print("    "+titleStr) ;
                }
                else if ( x.isResource() )
                {
                   Resource r = (Resource)x ;
                   System.out.print("    "+r.toString()) ;
                }
                else
                    System.out.print("  "+x) ;
                 
                
                RDFNode x2 = rb.get("type") ;
            
            // Check the type of the result value
            if ( x2.isLiteral() )
            {
                Literal titleStr2 = (Literal)x2  ;
                System.out.println("    "+titleStr2) ;
            }
            else if ( x2.isResource() )
            {
               Resource r = (Resource)x2 ;
               System.out.println("    "+r.toString()) ;
            }
            else
                System.out.println("   "+x2) ;
        }
       }
        
        finally
        {
            // QueryExecution objects should be closed to free any system resources 
            qexec.close() ;
        }
	}
	
	public static void main(String[] args) {
		
		Model model = createModel() ;
		model.write(System.out);
		
		String rules = "[rule1: (?a rdf:type ?b) (?b rdf:type ?c) -> (?a rdf:type ?c)]";
	    GenericRuleReasoner reasoner = new GenericRuleReasoner(Rule.parseRules(rules));
	    reasoner.setDerivationLogging(true);
	    InfModel inf = ModelFactory.createInfModel(reasoner, model);
		
		Model x = ModelFactory.createRDFSModel(model);
		System.out.println("\n\n***Query 1***\n\n");
		queryAllEntity(inf);
	}
}
