/*
 * Class of the project 'Metamodeling in RDF/RDFS'
 * course 'Seminario di Ingegneria del Software'
 */
package seminarioIS;

import com.hp.hpl.jena.rdf.model.*;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.vocabulary.*;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.query.*;
import com.hp.hpl.jena.query.ResultSet;


/**
 * @author Alberto Cerullo
 */
public class ConceptDescription {

	public static final String uri = "http://somewhere#";
	public static final String uriFN = "http://www.w3.org/2001/vcard-rdf/3.0#";
	public static final String uriRDF =	"http://www.w3.org/1999/02/22-rdf-syntax-ns#";
	public static final String uriRDFS = RDFS.getURI();
	public static final String NL = System.getProperty("line.separator") ;
	
	public static Model createModel()
    {
		
		//Setting the model and creating the data.
		Model m = ModelFactory.createDefaultModel() ;
        m.setNsPrefix( "uri", uri );
        
        //All definitions of the Resources of meta level
        Resource concept = m.createResource(uri + "Concept");
        Resource description = m.createResource(uri + "Description");
        concept.addProperty(RDF.type,RDFS.Class) ;
        description.addProperty(RDF.type,RDFS.Class) ;
        Property defines = m.createProperty(uri + "defines");
        defines.addProperty(RDFS.range,concept);
        defines.addProperty(RDFS.domain,description);
        Property usesConcept = m.createProperty(uri + "usesConcept");
        usesConcept.addProperty(RDFS.range,concept);
        usesConcept.addProperty(RDFS.domain,description);
        Property isConceptUsedIn = m.createProperty(uri + "isConceptUsedIn");
        isConceptUsedIn.addProperty(RDFS.range,description);
        isConceptUsedIn.addProperty(RDFS.domain,concept);
        Property isDefinedIn = m.createProperty(uri + "isDefinedIn");
        isDefinedIn.addProperty(RDFS.range,description);
        isDefinedIn.addProperty(RDFS.domain,concept);
        
        //All definitions of the Resources of intensional level
        Resource articolo = m.createResource(uri + "Articolo Scientifico");
        Resource algoritmo = m.createResource(uri + "Algoritmo");
        articolo.addProperty(RDF.type,description)
			.addProperty(RDF.type,RDFS.Class) ;
        algoritmo.addProperty(RDF.type,concept)
			.addProperty(RDF.type,RDFS.Class) ;
        Property usa = m.createProperty(uri + "usa");
        usa.addProperty(RDFS.range,algoritmo);
        usa.addProperty(RDFS.domain,articolo);
        usa.addProperty(RDF.type,usesConcept);
        Property definisceAlgoritmo = m.createProperty(uri + "definisceAlgoritmo");
        definisceAlgoritmo.addProperty(RDFS.range,algoritmo);
        definisceAlgoritmo.addProperty(RDFS.domain,articolo);
        definisceAlgoritmo.addProperty(RDF.type,defines);
        Property presenteIn = m.createProperty(uri + "presenteIn");
        presenteIn.addProperty(RDFS.range,articolo);
        presenteIn.addProperty(RDFS.domain,algoritmo);
        presenteIn.addProperty(RDF.type,isConceptUsedIn);
        Property autore = m.createProperty(uri + "autore");   
        autore.addProperty(RDFS.domain,articolo);
        
        //All definitions of the Resources of extensional level
        Resource articolo1 = m.createResource(uri + "Worst-case analysis of a new heuristic for the travelling salesman problem");
        Resource articolo2 = m.createResource(uri + "State of the art Algorithms for the Minimum Spanning Trees");
        Resource articolo3 = m.createResource(uri + "Solutio problematis ad geometriam situs pertinentis");
        Resource alg1 = m.createResource(uri + "Christofides algorithm");
        Resource alg2 = m.createResource(uri + "minimum spanning tree");
        Resource alg3 = m.createResource(uri + "Eulerian path");
        articolo1.addProperty(definisceAlgoritmo,alg1);
        articolo1.addProperty(usa,alg2);
        articolo1.addProperty(usa,alg3);
        articolo1.addProperty(RDF.type,articolo);
        articolo2.addProperty(definisceAlgoritmo,alg2);
        articolo3.addProperty(definisceAlgoritmo,alg3);
        alg1.addProperty(autore, "Christofides");
        alg3.addProperty(autore, "Euler");
        alg1.addProperty(RDF.type,algoritmo);
        alg2.addProperty(RDF.type,algoritmo);
        alg3.addProperty(RDF.type,algoritmo);
        
	return m;
    }
	
	public static void queryAllConceptInDescription(Model model)	{
	    String prolog = "PREFIX uri: <"+uri+">  PREFIX uriRDF: <"+uriRDF+">" ;
	    String queryString = prolog + NL +
        "SELECT  DISTINCT ?x ?p WHERE {?x uriRDF:"+
        	model.getProperty("type")+"  uri:"+
        	model.getResource("Concept")+". ?y uriRDF:" +        	
        	model.getProperty("type")+"  uri:"+
        	model.getResource("Description")+		" . ?y ?p ?x.}" ;
	    Query query = QueryFactory.create(queryString) ;
        // Print with line numbers
        query.serialize(new IndentedWriter(System.out,true)) ;
        System.out.println() ;
        QueryExecution qexec = QueryExecutionFactory.create(query, model) ;
        // Or QueryExecutionFactory.create(queryString, model) ;

        System.out.println("Tutti i Concetti relativi a Descrizioni: ") ;
        try {
            // Assumption: it's a SELECT query.
            ResultSet rs = qexec.execSelect() ;
            
            // The order of results is undefined. 
            for ( ; rs.hasNext() ; )
            {
                QuerySolution rb = rs.nextSolution() ;
                
                // Get title - variable names do not include the '?' (or '$')
                RDFNode x = rb.get("x") ;
                
                // Check the type of the result value
                if ( x.isLiteral() )
                {
                    Literal titleStr = (Literal)x  ;
                    System.out.print("    "+titleStr) ;
                }
                else if ( x.isResource() )
                {
                   Resource r = (Resource)x ;
                   System.out.print("    "+r.toString()) ;
                }
                else
                    System.out.print("  "+x) ;
                 
               
                
                
                RDFNode x2 = rb.get("p") ;
            
            // Check the type of the result value
            if ( x2.isLiteral() )
            {
                Literal titleStr2 = (Literal)x2  ;
                System.out.println("    "+titleStr2) ;
            }
            else if ( x2.isResource() )
            {
               Resource r = (Resource)x2 ;
               System.out.println("    "+r.toString()) ;
            }
            else
                System.out.println("   "+x2) ;
        }
       }
        
        finally
        {
            // QueryExecution objects should be closed to free any system resources 
            qexec.close() ;
        }
	}

	
	
	public static void main(String[] args) {
		Model model = createModel() ;
		model.write(System.out);
		
		String rules = "[rule1: (?a rdf:type ?b) (?b rdf:type ?c) -> (?a rdf:type ?c)]";
	    GenericRuleReasoner reasoner = new GenericRuleReasoner(Rule.parseRules(rules));
	    reasoner.setDerivationLogging(true);
	    InfModel inf = ModelFactory.createInfModel(reasoner, model);
		
		Model x = ModelFactory.createRDFSModel(model);
		System.out.println("\n\n***Query 1***\n\n");
		queryAllConceptInDescription(inf);
		
	}
}
