/*
 * Class of the project 'Metamodeling in RDF/RDFS'
 * course 'Seminario di Ingegneria del Software'
 */
package seminarioIS;

import com.hp.hpl.jena.rdf.model.*;
import com.hp.hpl.jena.vocabulary.*;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.query.*;
import com.hp.hpl.jena.query.ResultSet;


/**
 * @author Alberto Cerullo
 */
public class AnimaliCibo {

	public static final String uri = "http://somewhere#";
	public static final String uriFN = "http://www.w3.org/2001/vcard-rdf/3.0#";
	public static final String uriRDF =	"http://www.w3.org/1999/02/22-rdf-syntax-ns#";
	public static final String uriRDFS =	RDFS.getURI();
	public static final String NL = System.getProperty("line.separator") ;
	
	public static void main(String[] args) {
		Model model = createModel() ;
		model.write(System.out);
		Model x = ModelFactory.createRDFSModel(model);
		System.out.println("\n\n***Query 1***\n\n");
		queryProprietarioMangiaSuoAnimale(model);
		System.out.println("\n\n***Query 2***\n\n");
		queryProprietarioMangiaComeSuoAnimale(x);
		System.out.println("\n\n***Query 3***\n\n");
		queryChiMangia(x);
		
	}
	
	public static Model createModel()
    {
		//Setting the model and creating the data.
		Model m = ModelFactory.createDefaultModel() ;
        m.setNsPrefix( "uri", uri );
        
        //All definitions of the Resources of intensional level
        Resource cavallo = m.createResource(uri + "Cavallo") ;
        Resource mucca = m.createResource(uri + "Mucca") ;
        Resource erba = m.createResource(uri + "Erba") ;
        Resource insalata = m.createResource(uri + "Insalata") ;
        Resource animale = m.createResource(uri + "Animale") ;
         
        //All Property of intensional level with domain and range
            
        Property mangia = m.createProperty(uri + "mangia") ;
      
        
        mucca.addProperty(RDF.type,RDFS.Class) ;       
        cavallo.addProperty(RDF.type,RDFS.Class) ;
        erba.addProperty(RDF.type,RDFS.Class) ;
        insalata.addProperty(RDF.type,RDFS.Class) ;
        animale.addProperty(mangia, erba) ;
        mucca.addProperty(RDFS.subClassOf,animale);
        cavallo.addProperty(RDFS.subClassOf,animale);
        
        Resource persona = m.createResource(uri + "Persona") ;
        Property possiede  = m.createProperty( uri + "possiede" ) ;        
        possiede.addProperty(RDFS.domain , persona);
        persona.addProperty(RDF.type,RDFS.Class);
        
        //All elements of extensional level
        Resource person1 = m.createResource(uri + "JohnSmith") ;
        person1.addProperty(RDF.type , persona)
			.addProperty(VCARD.FN , "John Smith");
        Resource person2 = m.createResource(uri + "UncleTom") ;
        person2.addProperty(RDF.type , persona)
			.addProperty(VCARD.FN , "Uncle Tom");
        Resource horse1 = m.createResource(uri+ "Varenne") ;
        Resource cow1 = m.createResource(uri+ "Carolina") ;
        horse1.addProperty(RDF.type , cavallo);
        person1.addProperty(possiede,horse1) ;
        Property nomeAnimale = m.createProperty(uri + "nome") ;
        horse1.addProperty(nomeAnimale, "Varenne") ;
        cow1.addProperty(nomeAnimale, "Carolina") ;
        cow1.addProperty(RDF.type , mucca);
        person2.addProperty(possiede,cow1) ;
        
//      All definitions of the Resources of metalevel
        Resource carne = m.createResource(uri + "Carne") ;
        Resource verdura = m.createResource(uri + "Verdura") ;
        Resource cibo = m.createResource(uri + "Cibo") ;     
        
        Property pasto = m.createProperty(uri + "pasto") ;
        pasto.addProperty(RDFS.domain, persona) ;
        pasto.addProperty(RDFS.range, cibo) ;
      
        carne.addProperty(RDF.type,RDFS.Class);
        carne.addProperty(RDFS.subClassOf ,cibo );
        verdura.addProperty(RDF.type,RDFS.Class);
        verdura.addProperty(RDFS.subClassOf ,cibo );
        cibo.addProperty(RDF.type,RDFS.Class);
        
        //connection between intensional and metamodel level        
        cavallo.addProperty(RDF.type , carne) ;
        mucca.addProperty(RDF.type , carne) ;
        erba.addProperty(RDF.type , verdura) ;
        insalata.addProperty(RDF.type , verdura) ;
        
        //connection intra level
        person1.addProperty(pasto, carne) ;
        person2.addProperty(pasto, verdura) ;
        
        return m ;
    }
	
	public static void queryProprietarioMangiaSuoAnimale(Model model)	{
	    String prolog = "PREFIX uri: <"+uri+"> PREFIX uriFN: <"+uriFN+"> PREFIX uriRDF: <"+uriRDF+"> PREFIX uriRDFS: <"+uriRDFS+">" ;
	    String queryString = prolog + NL +
        "SELECT   ?nome ?nomeAnimale WHERE { ?x uri:"+
        	model.getProperty("possiede")+"	?animale ; " +
        	"uriFN:"+model.getProperty("FN")+" ?nome; uri:"+
			model.getProperty("pasto")+" ?cibo. ?animale uriRDF:"+
    		model.getProperty("type")+"?type; uri:"+
    		model.getProperty("nome")+"?nomeAnimale. ?type uriRDF:" +
			model.getProperty("type")+" ?cibo. }" ;
	    Query query = QueryFactory.create(queryString) ;
	    
        // Print with line numbers
        query.serialize(new IndentedWriter(System.out,true)) ;
        System.out.println() ;
        QueryExecution qexec = QueryExecutionFactory.create(query, model) ;
        // Or QueryExecutionFactory.create(queryString, model) ;

        System.out.println("ProprietarioMangia: ") ;
        try {
            // Assumption: it's a SELECT query.
            ResultSet rs = qexec.execSelect() ;
            
            // The order of results is undefined. 
            for ( ; rs.hasNext() ; )
            {
                QuerySolution rb = rs.nextSolution() ;
                
                // Get title - variable names do not include the '?' (or '$')
                RDFNode x = rb.get("nome") ;
                
                // Check the type of the result value
                if ( x.isLiteral() )
                {
                    Literal titleStr = (Literal)x  ;
                    System.out.print("    "+titleStr) ;
                }
                else if ( x.isResource() )
                {
                   Resource r = (Resource)x ;
                   System.out.print("    "+r.toString()) ;
                }
                else
                    System.out.print("  "+x) ;
                 
                
                RDFNode x2 = rb.get("nomeAnimale") ;
                
                // Check the type of the result value
                if ( x2.isLiteral() )
                {
                    Literal titleStr2 = (Literal)x2  ;
                    System.out.println("    "+titleStr2) ;
                }
                else if ( x2.isResource() )
                {
                   Resource r = (Resource)x2 ;
                   System.out.println("    "+r.toString()) ;
                }
                else
                    System.out.println("  "+x2) ;
                
            }
        }
        finally
        {
            // QueryExecution objects should be closed to free any system resources 
            qexec.close() ;
        }
	}

	public static void queryProprietarioMangiaComeSuoAnimale(Model model)	{
	    String prolog = "PREFIX uri: <"+uri+"> PREFIX uriFN: <"+uriFN+"> PREFIX uriRDF: <"+uriRDF+"> PREFIX uriRDFS: <"+uriRDFS+">" ;
	    String queryString = prolog + NL +
        "SELECT   ?nome ?nomeAnimale ?cibo WHERE { ?x uri:"+
        	model.getProperty("possiede")+"	?animale ; " +
        	"uriFN:"+model.getProperty("FN")+" ?nome; uri:"+
			model.getProperty("pasto")+" ?cibo.?animale uri:"+
    		model.getProperty("nome")+"?nomeAnimale; uriRDF:"+
    		model.getProperty("type")+" ?tipoAnimale. ?tipoAnimale  uri:"+
    		model.getProperty("mangia")+"?ciboAnimale. ?ciboAnimale uriRDF:" +
			model.getProperty("type")+" ?cibo.  }" ;
	    Query query = QueryFactory.create(queryString) ;
	    
        // Print with line numbers
        query.serialize(new IndentedWriter(System.out,true)) ;
        System.out.println() ;
        QueryExecution qexec = QueryExecutionFactory.create(query, model) ;
        // Or QueryExecutionFactory.create(queryString, model) ;

        System.out.println("ProprietarioMangiaComeSuoAnimale: ") ;
        try {
            // Assumption: it's a SELECT query.
            ResultSet rs = qexec.execSelect() ;
            
            // The order of results is undefined. 
            for ( ; rs.hasNext() ; )
            {
                QuerySolution rb = rs.nextSolution() ;
                
                // Get title - variable names do not include the '?' (or '$')
                RDFNode x = rb.get("nome") ;
                
                // Check the type of the result value
                if ( x.isLiteral() )
                {
                    Literal titleStr = (Literal)x  ;
                    System.out.print("    "+titleStr) ;
                }
                else if ( x.isResource() )
                {
                   Resource r = (Resource)x ;
                   System.out.print("    "+r.toString()) ;
                }
                else
                    System.out.print("  "+x) ;
                 
                
                RDFNode x2 = rb.get("nomeAnimale") ;
                
                // Check the type of the result value
                if ( x2.isLiteral() )
                {
                    Literal titleStr2 = (Literal)x2  ;
                    System.out.print("    "+titleStr2) ;
                }
                else if ( x2.isResource() )
                {
                   Resource r = (Resource)x2 ;
                   System.out.print("    "+r.toString()) ;
                }
                else
                    System.out.print("   "+x2) ;
                
            
            RDFNode x3 = rb.get("cibo") ;
            
            // Check the type of the result value
            if ( x3.isLiteral() )
            {
                Literal titleStr2 = (Literal)x3  ;
                System.out.println("    "+titleStr2) ;
            }
            else if ( x3.isResource() )
            {
               Resource r = (Resource)x3 ;
               System.out.println("    "+r.toString()) ;
            }
            else
                System.out.println("   "+x3) ;
            
        
        }
       }
        
        finally
        {
            // QueryExecution objects should be closed to free any system resources 
            qexec.close() ;
        }
	}


	public static void queryChiMangia(Model model)	{
	    String prolog = "PREFIX uri: <"+uri+"> PREFIX uriFN: <"+uriFN+"> PREFIX uriRDF: <"+uriRDF+"> " ;
	    String queryString = prolog + NL +
        "SELECT   ?nome ?cibo WHERE { {?x uriFN:"+
        	model.getProperty("FN")+" ?nome; uri:"+
			model.getProperty("pasto")+" ?cibo.} " +
        " UNION{?x uri:"+
        	model.getProperty("nome")+" ?nome; uriRDF:"+
        	model.getProperty("type")+" ?type. ?type uri:"+
			model.getProperty("mangia")+" ?cibo. } }" ;
	    Query query = QueryFactory.create(queryString) ;
	    
        // Print with line numbers
        query.serialize(new IndentedWriter(System.out,true)) ;
        System.out.println() ;
        QueryExecution qexec = QueryExecutionFactory.create(query, model) ;
        // Or QueryExecutionFactory.create(queryString, model) ;

        System.out.println("Esseri che mangiano: ") ;
        try {
            // Assumption: it's a SELECT query.
            ResultSet rs = qexec.execSelect() ;
            
            // The order of results is undefined. 
            for ( ; rs.hasNext() ; )
            {
                QuerySolution rb = rs.nextSolution() ;
                
                // Get title - variable names do not include the '?' (or '$')
                RDFNode x = rb.get("nome") ;
                
                // Check the type of the result value
                if ( x.isLiteral() )
                {
                    Literal titleStr = (Literal)x  ;
                    System.out.print("    "+titleStr) ;
                }
                else if ( x.isResource() )
                {
                   Resource r = (Resource)x ;
                   System.out.print("    "+r.toString()) ;
                }
                else
                    System.out.print("   "+x) ;
                 
                
                RDFNode x2 = rb.get("cibo") ;
            
            // Check the type of the result value
            if ( x2.isLiteral() )
            {
                Literal titleStr2 = (Literal)x2  ;
                System.out.println("    "+titleStr2) ;
            }
            else if ( x2.isResource() )
            {
               Resource r = (Resource)x2 ;
               System.out.println("    "+r.toString()) ;
            }
            else
                System.out.println("   "+x2) ;
            
        
        }
       }
        
        finally
        {
            // QueryExecution objects should be closed to free any system resources 
            qexec.close() ;
        }
	}
	
	

}