// File Animale.java
// ANIMALE

interface Animale {
  public String getOrdine();
  public String getGenere();
  public String getSpecie();
  public String getCiboPreferito();
}

class AnimaleIMP implements Animale {

  protected String cibo_preferito, ordine, genere, specie;

  public AnimaleIMP(String o, String g, String s, String c) {
    ordine = o; genere = g; specie = s; cibo_preferito = c;
  }
  public String getOrdine() {
    return ordine;
  }
  public String getGenere() {
    return genere;
  }
  public String getSpecie() {
    return specie;
  }
  public String getCiboPreferito() {
    return cibo_preferito;
  }
}


//MAMMIFERO
interface Mammifero extends Animale {
  public int getMesiDiGestazione();
}


class MammiferoIMP implements Animale {
  private AnimaleIMP animale;	//NOTA!
  private int mesi_di_gestazione;
  public MammiferoIMP(String g, String s, String c, int m) {
    animale = new AnimaleIMP("Mammifero",g,s,c);
    mesi_di_gestazione = m;
  }
  public String getOrdine() {  //NOTA!
    return animale.getOrdine();  
  }
  public String getGenere() { //NOTA!
    return animale.getGenere();
  }
  public String getSpecie() { //NOTA!
    return animale.getSpecie();
  }
  public String getCiboPreferito() { //NOTA!
    return animale.getCiboPreferito();
  }
  public int getMesiDiGestazione() { return mesi_di_gestazione; }
}


//ACQUATICO

interface Acquatico extends Animale {
  public float getMaxSalinitaAcqua();
}

class AcquaticoIMP implements Acquatico {
  private AnimaleIMP animale;	//NOTA!
  private float max_salinita_acqua;
  public AcquaticoIMP(String o, String g, String s, String c, float m) {
    animale = new AnimaleIMP(o,g,s,c);
    max_salinita_acqua = m;
  }
  public String getOrdine() {  //NOTA!
    return animale.getOrdine();  
  }
  public String getGenere() { //NOTA!
    return animale.getGenere();
  }
  public String getSpecie() { //NOTA!
    return animale.getSpecie();
  }
  public String getCiboPreferito() { //NOTA!
    return animale.getCiboPreferito();
  }
  public float getMaxSalinitaAcqua() {
    return max_salinita_acqua;
  }
}


//CETACEO

interface Cetaceo extends Mammifero, Acquatico {
public boolean getPresenteInItalia();
}

class CetaceoIMP implements Cetaceo {

  private MammiferoIMP mammifero;  //NOTA!
  private AcquaticoIMP acquatico;   //NOTA!
  protected boolean presente_in_italia;
  public CetaceoIMP(String g, String s, String c, int me, float ma, boolean p) {
    mammifero = new MammiferoIMP(g,s,c,me);
    acquatico = new AcquaticoIMP("Mammifero",g,s,c,ma);
    presente_in_italia = p;
  }

  public String getOrdine() {  //NOTA!
    return mammifero.getOrdine();  
  }
  public String getGenere() { //NOTA!
    return mammifero.getGenere();
  //  oppure
  //return acquatico.getGenere();
  }
  public String getSpecie() { //NOTA!
    return mammifero.getSpecie();
  //  oppure
  //return acquatico.getGenere();
  }
  public String getCiboPreferito() { //NOTA!
    return mammifero.getCiboPreferito();
  //  oppure
  //return acquatico.getGenere();
  }
  public int getMesiDiGestazione() { 
    return mammifero.getMesiDiGestazione();
  }
  public float getMaxSalinitaAcqua() {
    return acquatico.getMaxSalinitaAcqua();
  }
  public boolean getPresenteInItalia() { return presente_in_italia; }
}

