package penitenzeSubite;

import partecipante.Partecipante;
import penitenza.Penitenza;

public class TipoLinkPenitenzeSubite {
	private final Partecipante ilPartecipante;
	private final Penitenza laPenitenza;
	private final int numeroVolte;

	public TipoLinkPenitenzeSubite(Partecipante x, Penitenza y, int n) {
		if (x == null || y == null) // CONTROLLO PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		ilPartecipante = x;
		laPenitenza = y;
		numeroVolte = n;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkPenitenzeSubite b = (TipoLinkPenitenzeSubite) o;
			return b.ilPartecipante == ilPartecipante
					&& b.laPenitenza == laPenitenza;
		} else
			return false;
	}

	public int hashCode() {
		return laPenitenza.hashCode() + ilPartecipante.hashCode();
	}

	public Penitenza getPenitenza() {
		return laPenitenza;
	}

	public Partecipante getPartecipante() {
		return ilPartecipante;
	}

	public int getNumeroVolte() {
		return numeroVolte;
	}

}
