package partita;

import giocatori.*;
import java.util.*;

import penitenza.*;

public class Partita {
	private final String nome;

	private ArrayList<Penitenza> penitenzePossibili;
	public final int MIN = 1;

	private ArrayList<TipoLinkGiocatori> giocatori;

	public Partita(String n) {
		nome = n;
		penitenzePossibili = new ArrayList<Penitenza>();
		giocatori = new ArrayList<TipoLinkGiocatori>();
	}

	public String getNome() {
		return nome;
	}

	// Gestione associazione penitenzePossibili
	// Responsabilita' singola da parte di Partita
	public void inserisciLinkPenitenzePossibili(Penitenza p) {
		if (p != null)
			penitenzePossibili.add(p);
	}

	public void eliminaLinkPenitenzePossibili(Penitenza p) {
		if (p != null && penitenzePossibili.size() > MIN)
			penitenzePossibili.remove(p);
		else
			throw new RuntimeException("Eccezione");
	}

	@SuppressWarnings("unchecked")
	public List<Penitenza> getLinkPenitenzePossibili() {
		if (penitenzePossibili.size() < MIN)
			throw new RuntimeException("Eccezione Molteplicita'");
		return (ArrayList<Penitenza>) penitenzePossibili.clone();
	}

	// usato per scegliere una penitenza possibile
	public Penitenza scegliPenitenzaRandom() {
		Random r = new Random();
		int quante = this.penitenzePossibili.size();
		int indice = r.nextInt(quante);
		return this.penitenzePossibili.get(indice);
	}

	// Gestione associazione giocatori
	// Responsabilita' doppia
	public void inserisciLinkGiocatori(TipoLinkGiocatori t) {
		if (t != null && t.getPartita() == this)
			ManagerGiocatori.inserisci(t);
	}

	public void eliminaLinkGiocatori(TipoLinkGiocatori t) {
		if (t != null && t.getPartita() == this)
			ManagerGiocatori.elimina(t);
	}

	@SuppressWarnings("unchecked")
	public List<TipoLinkGiocatori> getLinkGiocatori() {
		return (ArrayList<TipoLinkGiocatori>) giocatori.clone();
	}

	public void inserisciPerManagerGiocatori(ManagerGiocatori a) {
		if (a != null && !giocatori.contains(a.getLink()))
			giocatori.add(a.getLink());
	}

	public void eliminaPerManagerGiocatori(ManagerGiocatori a) {
		if (a != null)
			giocatori.remove(a.getLink());
	}

	public int quantiGiocatori() {
		return giocatori.size();
	}

	public String toString() {
		return "Partita: " + nome;
	}
}
