package partecipante;

import java.util.Iterator;
import java.util.Random;

import penitenza.Penitenza;
import penitenzeSubite.TipoLinkPenitenzeSubite;

import eventi.Fine;
import eventi.Inizio;
import eventi.Bottiglia;
import _framework.Executor;
import _framework.Task;
import _gestioneeventi.Environment;
import _gestioneeventi.Evento;

class PartecipanteFired implements Task {
	private boolean eseguita = false;
	private Partecipante g;
	private Evento e;

	public PartecipanteFired(Partecipante g, Evento e) {
		this.g = g;
		this.e = e;
	}

	// usato per scegliere a chi lanciare la bottiglia
	private Partecipante scegliPartecipante() {
		Random r = new Random();
		int quanti = g.getLinkGiocatori().getPartita().quantiGiocatori();
		int rilanciaA = r.nextInt(quanti);
		return g.getLinkGiocatori().getPartita().getLinkGiocatori().get(
				rilanciaA).getPartecipante();
	}

	public synchronized void esegui(Executor exec) {
		if (eseguita || exec == null
				|| (e.getDestinatario() != g && e.getDestinatario() != null))
			return;
		eseguita = true;
		System.out.println("Entrato nel fired di " + g);

		switch (g.getStato()) {
		case NONINGIOCO:
			if (e.getClass() == Inizio.class) {
				g.azzeraPenitenzeSubite();
				g.statocorrente = partecipante.Partecipante.Stato.INGIOCO;
			}
			break;
		case INGIOCO:
			if (e.getClass() == Bottiglia.class) {

				Bottiglia d = (Bottiglia) e;
				System.out.println(d);

				Partecipante dest = this.scegliPartecipante();
				System.out.println(d.getDestinatario()
						+ " ha deciso di rilanciare a " + dest);

				if (e.getMittente() != null
						&& e.getMittente().getClass() != g.getClass()) {
					Penitenza p = g.getLinkGiocatori().getPartita()
							.scegliPenitenzaRandom();
					System.out.println(g + " subisce la penitenza " + p);

					TipoLinkPenitenzeSubite nuovo = new TipoLinkPenitenzeSubite(
							g, p, 0);
					Iterator<TipoLinkPenitenzeSubite> it = g
							.getLinkPenitenzeSubite().iterator();
					Boolean trovato = false;
					int nuovoValore = 1;
					TipoLinkPenitenzeSubite aux = null;
					while (!trovato && it.hasNext()) {
						aux = it.next();
						if (aux.equals(nuovo))
							trovato = true;
					}
					if (trovato)
						nuovoValore = aux.getNumeroVolte() + 1;

					nuovo = new TipoLinkPenitenzeSubite(g, p, nuovoValore);
					g.eliminaLinkPenitenzeSubite(aux);
					g.inserisciLinkPenitenzeSubite(nuovo);
					System.out.println(g.visualizzaPenitenzeSubite());
				}

				Environment.aggiungiEvento(new Bottiglia(g, dest));
			} else if (e.getClass() == Fine.class)
				g.statocorrente = partecipante.Partecipante.Stato.NONINGIOCO;
			break;
		default:
			throw new RuntimeException("Stato corrente non riconosciuto.");
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
