package partecipante;

import giocatori.ManagerGiocatori;
import giocatori.TipoLinkGiocatori;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import penitenza.Penitenza;
import penitenzeSubite.TipoLinkPenitenzeSubite;
import _framework.*;
import _gestioneeventi.*;

public abstract class Partecipante implements Listener {
	private final String nome;
	private String avatar;
	ArrayList<TipoLinkPenitenzeSubite> penitenzeSubite;
	TipoLinkGiocatori partita;

	public Partecipante(String n) {
		nome = n;
		penitenzeSubite = new ArrayList<TipoLinkPenitenzeSubite>();
		partita = null;
	}

	public String getNome() {
		return nome;
	}

	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		if (statocorrente != Stato.NONINGIOCO)
			throw new RuntimeException(
					"Non si puo' modificare il giocatore se non e' in allenamento");
		this.avatar = avatar;
	}

	public String toString() {
		return "Partecipante: " + nome;
	}

	// Gestione associazione penitenzeSubite
	// Responsabilita' singola da parte di Partecipante

	public void azzeraPenitenzeSubite() {
		penitenzeSubite = null;
		penitenzeSubite = new ArrayList<TipoLinkPenitenzeSubite>();
	}

	public String visualizzaPenitenzeSubite() {
		String daVisualizzare = "Penitenze di " + this.getNome() + ": ";
		Iterator<TipoLinkPenitenzeSubite> it = penitenzeSubite.iterator();
		while (it.hasNext()) {
			TipoLinkPenitenzeSubite aux = it.next();
			Penitenza p = aux.getPenitenza();
			int quanteVolte = aux.getNumeroVolte();
			daVisualizzare = daVisualizzare + "(" + p.toString() + ", "
					+ quanteVolte + ")";
		}
		return daVisualizzare;

	}

	public void inserisciLinkPenitenzeSubite(TipoLinkPenitenzeSubite p) {
		if (p != null)
			penitenzeSubite.add(p);

	}

	public void eliminaLinkPenitenzeSubite(TipoLinkPenitenzeSubite p) {
		if (p != null)
			penitenzeSubite.remove(p);
	}

	@SuppressWarnings("unchecked")
	public List<TipoLinkPenitenzeSubite> getLinkPenitenzeSubite() {
		return (ArrayList<TipoLinkPenitenzeSubite>) penitenzeSubite.clone();
	}

	// Gestione associazione giocatori
	// Responsabilita' doppia
	public void inserisciLinkGiocatori(TipoLinkGiocatori t) {
		if (t != null && t.getPartecipante() == this && partita == null)
			ManagerGiocatori.inserisci(t);
		else
			throw new RuntimeException("ERRORE");
	}

	public void eliminaLinkGiocatori(TipoLinkGiocatori t) {
		if (t != null && t.getPartecipante() == this && partita != null)
			ManagerGiocatori.elimina(t);
		else
			throw new RuntimeException("ERRORE");
	}

	public TipoLinkGiocatori getLinkGiocatori() {
		if (partita != null)
			return partita;
		else
			throw new RuntimeException("ERRORE");
	}

	public void inserisciPerManagerGiocatori(ManagerGiocatori a) {
		if (a != null && partita == null)
			partita = a.getLink();
	}

	public void eliminaPerManagerGiocatori(ManagerGiocatori a) {
		if (a != null && partita != null)
			partita = null;
	}

	// gestione stato

	public static enum Stato {
		NONINGIOCO, INGIOCO
	}

	Stato statocorrente = Stato.NONINGIOCO;

	public Stato getStato() {
		return statocorrente;
	}

	public void fired(Evento e) {
		Executor.perform(new PartecipanteFired(this, e));
	}

}
