package giocatori;

import partecipante.Partecipante;
import partita.*;

public class TipoLinkGiocatori {
	private final Partecipante ilPartecipante;
	private final Partita laPartita;

	public TipoLinkGiocatori(Partecipante x, Partita y) {
		if (x == null || y == null) // CONTROLLO PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		ilPartecipante = x;
		laPartita = y;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkGiocatori b = (TipoLinkGiocatori) o;
			return b.ilPartecipante == ilPartecipante
					&& b.laPartita == laPartita;
		} else
			return false;
	}

	public int hashCode() {
		return laPartita.hashCode() + ilPartecipante.hashCode();
	}

	public Partita getPartita() {
		return laPartita;
	}

	public Partecipante getPartecipante() {
		return ilPartecipante;
	}
}
