package giocatori;

import partecipante.*;

public final class ManagerGiocatori {
	private ManagerGiocatori(TipoLinkGiocatori x) {
		link = x;
	}

	private TipoLinkGiocatori link;

	public TipoLinkGiocatori getLink() {
		return link;
	}

	public static void inserisci(TipoLinkGiocatori y) {
		if (y != null) {
			if (y.getPartecipante().getStato() != Partecipante.Stato.NONINGIOCO)
				throw new RuntimeException(
						"Non si puo' modificare un partecipante mentre sta giocando");
			ManagerGiocatori k = new ManagerGiocatori(y);
			y.getPartecipante().inserisciPerManagerGiocatori(k);
			y.getPartita().inserisciPerManagerGiocatori(k);
		}
	}

	public static void elimina(TipoLinkGiocatori y) {
		if (y != null) {
			if (y.getPartecipante().getStato() != Partecipante.Stato.NONINGIOCO)
				throw new RuntimeException(
						"Non si puo' modificare un giocatore mentre sta giocando");
			ManagerGiocatori k = new ManagerGiocatori(y);
			y.getPartecipante().eliminaPerManagerGiocatori(k);
			y.getPartita().eliminaPerManagerGiocatori(k);
		}
	}
}
