package attivita_composte;

import giocatori.TipoLinkGiocatori;

import java.util.HashSet;
import java.util.Iterator;

import partecipante.Partecipante;
import partita.Partita;
import penitenza.Penitenza;

import _framework.Executor;
import attivita_atomiche.InserimentoGiocatori;
import attivita_atomiche.VerificaGioc;
import attivita_io.LetturaGiocatori;
import attivita_io.VisualizzaErrore;
import attivita_io.VisualizzaSaluto;

public class AttivitaPrincipale implements Runnable {

	private boolean eseguita = false;
	private Partita partita;
	private HashSet<Partecipante> pp;
	private Boolean ok;

	public AttivitaPrincipale(Partita t) {
		this.partita = t;
	}

	public synchronized void run() {
		if (eseguita == true)
			return;
		eseguita = true;

		LetturaGiocatori.perform();
		pp = LetturaGiocatori.getInsiemePartecipanti();

		InserimentoGiocatori iit = new InserimentoGiocatori(partita, pp);
		Executor.perform(iit);

		VerificaGioc vg = new VerificaGioc(partita);
		Executor.perform(vg);
		ok = vg.getResult();

		// Stampa di verifica
		System.out.println(partita);
		Iterator<Penitenza> it = partita.getLinkPenitenzePossibili().iterator();
		while (it.hasNext())
			System.out.println(it.next());

		Iterator<TipoLinkGiocatori> itg = partita.getLinkGiocatori().iterator();
		while (itg.hasNext())
			System.out.println(itg.next().getPartecipante());

		if (ok) {
			AttivitaSottoramo1 a1 = new AttivitaSottoramo1(partita);
			Thread ramo1 = new Thread(a1);
			ramo1.start();

			AttivitaSottoramo2 a2 = new AttivitaSottoramo2();
			Thread ramo2 = new Thread(a2);
			ramo2.start();

			try {
				ramo1.join();
				ramo2.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}

			VisualizzaSaluto.perform();
		} else
			VisualizzaErrore.perform();

	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
