package attivita_atomiche;

import giocatori.TipoLinkGiocatori;

import java.util.Iterator;

import partecipante.Partecipante;
import partita.Partita;
import ragazzo.Ragazzo;

import _framework.Executor;
import _framework.Task;

public class VerificaGioc implements Task {

	private boolean eseguita = false;
	private Partita partita;
	private Boolean result;

	public VerificaGioc(Partita p) {
		this.partita = p;
	}

	public synchronized void esegui(Executor e) {

		if (e == null || eseguita == true)
			return;
		eseguita = true;

		Boolean trovatoRagazzo = false;
		Boolean trovataRagazza = false;

		Iterator<TipoLinkGiocatori> it = partita.getLinkGiocatori().iterator();
		while (it.hasNext()) {
			Partecipante p = it.next().getPartecipante();
			if (p.getClass() == Ragazzo.class)
				trovatoRagazzo = true;
			else
				trovataRagazza = true;
		}

		result = trovatoRagazzo && trovataRagazza;

	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

	public synchronized boolean getResult() {
		return result;
	}
}