package attivita_atomiche;

import giocatori.TipoLinkGiocatori;

import java.util.HashSet;
import java.util.Iterator;

import partecipante.Partecipante;
import partita.Partita;

import _framework.Executor;
import _framework.Task;

public class InserimentoGiocatori implements Task {

	private boolean eseguita = false;
	private HashSet<Partecipante> hsP;
	private Partita partita;

	public InserimentoGiocatori(Partita p, HashSet<Partecipante> hsP) {
		this.partita = p;
		this.hsP = hsP;
	}

	public synchronized void esegui(Executor e) {

		if (e == null || eseguita == true)
			return;
		eseguita = true;

		Iterator<Partecipante> it = hsP.iterator();
		while (it.hasNext())
			partita.inserisciLinkGiocatori(new TipoLinkGiocatori(it.next(),
					partita));

	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

}